/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.domain;

import de.adorsys.psd2.xs2a.domain.MessageErrorCode;
import de.adorsys.psd2.xs2a.exception.MessageCategory;
import javax.validation.constraints.Size;

public class TppMessageInformation {
    private MessageCategory category;
    private MessageErrorCode messageErrorCode;
    private String path;
    @Size(max=512)
    private @Size(max=512) String text;

    public static TppMessageInformation of(MessageErrorCode messageErrorCode) {
        return TppMessageInformation.of(MessageCategory.ERROR, messageErrorCode, null);
    }

    public static TppMessageInformation of(MessageErrorCode messageErrorCode, String text) {
        return TppMessageInformation.of(MessageCategory.ERROR, messageErrorCode, text);
    }

    public static TppMessageInformation of(MessageCategory category, MessageErrorCode messageErrorCode) {
        return TppMessageInformation.of(category, messageErrorCode, null, null);
    }

    public static TppMessageInformation of(MessageCategory category, MessageErrorCode messageErrorCode, String text) {
        return TppMessageInformation.of(category, messageErrorCode, text, null);
    }

    public static TppMessageInformation of(MessageCategory category, MessageErrorCode messageErrorCode, String text, String path) {
        return new TppMessageInformation(category, messageErrorCode, text, path);
    }

    private TppMessageInformation(MessageCategory category, MessageErrorCode messageErrorCode, String text, String path) {
        this.category = category;
        this.messageErrorCode = messageErrorCode;
        this.text = text;
        this.path = path;
    }

    public MessageCategory getCategory() {
        return this.category;
    }

    public MessageErrorCode getMessageErrorCode() {
        return this.messageErrorCode;
    }

    public String getPath() {
        return this.path;
    }

    public String getText() {
        return this.text;
    }

    public void setCategory(MessageCategory category) {
        this.category = category;
    }

    public void setMessageErrorCode(MessageErrorCode messageErrorCode) {
        this.messageErrorCode = messageErrorCode;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setText(String text) {
        this.text = text;
    }

    public String toString() {
        return "TppMessageInformation(category=" + (Object)((Object)this.getCategory()) + ", messageErrorCode=" + (Object)((Object)this.getMessageErrorCode()) + ", path=" + this.getPath() + ", text=" + this.getText() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TppMessageInformation)) {
            return false;
        }
        TppMessageInformation other = (TppMessageInformation)o;
        if (!other.canEqual(this)) {
            return false;
        }
        MessageCategory this$category = this.getCategory();
        MessageCategory other$category = other.getCategory();
        if (this$category == null ? other$category != null : !((Object)((Object)this$category)).equals((Object)other$category)) {
            return false;
        }
        MessageErrorCode this$messageErrorCode = this.getMessageErrorCode();
        MessageErrorCode other$messageErrorCode = other.getMessageErrorCode();
        if (this$messageErrorCode == null ? other$messageErrorCode != null : !((Object)((Object)this$messageErrorCode)).equals((Object)other$messageErrorCode)) {
            return false;
        }
        String this$path = this.getPath();
        String other$path = other.getPath();
        if (this$path == null ? other$path != null : !this$path.equals(other$path)) {
            return false;
        }
        String this$text = this.getText();
        String other$text = other.getText();
        return !(this$text == null ? other$text != null : !this$text.equals(other$text));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TppMessageInformation;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        MessageCategory $category = this.getCategory();
        result = result * 59 + ($category == null ? 43 : ((Object)((Object)$category)).hashCode());
        MessageErrorCode $messageErrorCode = this.getMessageErrorCode();
        result = result * 59 + ($messageErrorCode == null ? 43 : ((Object)((Object)$messageErrorCode)).hashCode());
        String $path = this.getPath();
        result = result * 59 + ($path == null ? 43 : $path.hashCode());
        String $text = this.getText();
        result = result * 59 + ($text == null ? 43 : $text.hashCode());
        return result;
    }
}

