/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.web.validator.methods;

import de.adorsys.psd2.xs2a.web.validator.AbstractHeadersValidator;
import de.adorsys.psd2.xs2a.web.validator.HeadersValidator;
import de.adorsys.psd2.xs2a.web.validator.methods.MethodHeadersValidator;
import de.adorsys.psd2.xs2a.web.validator.methods.factory.HeadersValidationServiceFactory;
import java.beans.ConstructorProperties;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.stereotype.Component;
import org.springframework.web.method.HandlerMethod;

@Component
public class SpecificMethodsHeadersValidator
extends AbstractHeadersValidator {
    private final HeadersValidationServiceFactory headersValidationServiceFactory;

    @Override
    protected boolean validateThis(HttpServletRequest request, HttpServletResponse response, Object handler) throws IOException {
        if (handler instanceof HandlerMethod) {
            HandlerMethod handlerMethod = (HandlerMethod)handler;
            String methodName = handlerMethod.getMethod().getName();
            List availableMethods = Arrays.stream(MethodsForSpecificHeaderValidationAvailableMethods.values()).map(MethodsForSpecificHeaderValidationAvailableMethods::getValue).collect(Collectors.toList());
            if (availableMethods.contains(methodName)) {
                MethodHeadersValidator validator = (MethodHeadersValidator)this.headersValidationServiceFactory.getService(methodName);
                return validator.validate(request, response);
            }
            return true;
        }
        return false;
    }

    @Override
    public HeadersValidator getNextValidator() {
        return null;
    }

    @ConstructorProperties(value={"headersValidationServiceFactory"})
    public SpecificMethodsHeadersValidator(HeadersValidationServiceFactory headersValidationServiceFactory) {
        this.headersValidationServiceFactory = headersValidationServiceFactory;
    }

    public static enum MethodsForSpecificHeaderValidationAvailableMethods {
        CREATE_CONSENT("_createConsent"),
        INITIATE_PAYMENT("_initiatePayment");

        private String value;

        private MethodsForSpecificHeaderValidationAvailableMethods(String value) {
            this.value = value;
        }

        public String getValue() {
            return String.valueOf(this.value);
        }
    }
}

