/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.web.validator.common.service;

import de.adorsys.psd2.xs2a.domain.MessageErrorCode;
import de.adorsys.psd2.xs2a.domain.TppMessageInformation;
import de.adorsys.psd2.xs2a.service.discovery.ServiceTypeDiscoveryService;
import de.adorsys.psd2.xs2a.service.mapper.psd2.ErrorType;
import de.adorsys.psd2.xs2a.service.mapper.psd2.ServiceTypeToErrorTypeMapper;
import de.adorsys.psd2.xs2a.service.validator.ValidationResult;
import java.beans.ConstructorProperties;
import java.util.Objects;
import java.util.regex.Pattern;
import org.springframework.stereotype.Service;

@Service
public class XRequestIdValidationService {
    private static final String UUID_REGEX = "^[0-9a-f]{8}-[0-9a-f]{4}-[1-5][0-9a-f]{3}-[89ab][0-9a-f]{3}-[0-9a-f]{12}\\z";
    private static final String ERROR_TEXT_NULL_HEADER = "'X-Request-ID' may not be null";
    private static final String ERROR_TEXT_WRONG_HEADER = "'X-Request-ID' has to be represented by standard 36-char UUID representation";
    private static final Pattern PATTERN = Pattern.compile("^[0-9a-f]{8}-[0-9a-f]{4}-[1-5][0-9a-f]{3}-[89ab][0-9a-f]{3}-[0-9a-f]{12}\\z", 2);
    private final ServiceTypeDiscoveryService serviceTypeDiscoveryService;
    private final ServiceTypeToErrorTypeMapper errorTypeMapper;

    public ValidationResult validateXRequestId(String xRequestId) {
        if (Objects.isNull(xRequestId)) {
            return ValidationResult.invalid(this.buildErrorType(), TppMessageInformation.of(MessageErrorCode.FORMAT_ERROR, ERROR_TEXT_NULL_HEADER));
        }
        if (this.isNonValid(xRequestId)) {
            return ValidationResult.invalid(this.buildErrorType(), TppMessageInformation.of(MessageErrorCode.FORMAT_ERROR, ERROR_TEXT_WRONG_HEADER));
        }
        return ValidationResult.valid();
    }

    private ErrorType buildErrorType() {
        return this.errorTypeMapper.mapToErrorType(this.serviceTypeDiscoveryService.getServiceType(), MessageErrorCode.FORMAT_ERROR.getCode());
    }

    private boolean isNonValid(String xRequestId) {
        return !PATTERN.matcher(xRequestId).matches();
    }

    @ConstructorProperties(value={"serviceTypeDiscoveryService", "errorTypeMapper"})
    public XRequestIdValidationService(ServiceTypeDiscoveryService serviceTypeDiscoveryService, ServiceTypeToErrorTypeMapper errorTypeMapper) {
        this.serviceTypeDiscoveryService = serviceTypeDiscoveryService;
        this.errorTypeMapper = errorTypeMapper;
    }
}

