/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.web.validator;

import com.fasterxml.jackson.databind.ObjectMapper;
import de.adorsys.psd2.xs2a.domain.MessageErrorCode;
import de.adorsys.psd2.xs2a.domain.TppMessageInformation;
import de.adorsys.psd2.xs2a.exception.MessageError;
import de.adorsys.psd2.xs2a.service.discovery.ServiceTypeDiscoveryService;
import de.adorsys.psd2.xs2a.service.mapper.psd2.ErrorMapperContainer;
import de.adorsys.psd2.xs2a.service.mapper.psd2.ErrorType;
import de.adorsys.psd2.xs2a.service.mapper.psd2.ServiceTypeToErrorTypeMapper;
import java.beans.ConstructorProperties;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import javax.servlet.http.HttpServletResponse;
import org.springframework.stereotype.Component;

@Component
public class ErrorBuildingService {
    private final ServiceTypeDiscoveryService serviceTypeDiscoveryService;
    private final ServiceTypeToErrorTypeMapper errorTypeMapper;
    private final ErrorMapperContainer errorMapperContainer;
    private final ObjectMapper objectMapper;

    public void buildErrorResponse(HttpServletResponse response, MessageError messageError) throws IOException {
        response.resetBuffer();
        response.setCharacterEncoding("UTF-8");
        response.setContentType("application/json");
        TppMessageInformation tppMessageInformation = messageError.getTppMessage();
        response.setStatus(tppMessageInformation.getMessageErrorCode().getCode());
        response.getWriter().write(this.objectMapper.writeValueAsString(this.createError(Collections.singleton(tppMessageInformation.getText()))));
        response.flushBuffer();
    }

    private Object createError(Collection<String> errorMessages) {
        MessageError messageError = this.getMessageError(errorMessages);
        return Optional.ofNullable(this.errorMapperContainer.getErrorBody(messageError)).map(ErrorMapperContainer.ErrorBody::getBody).orElse(null);
    }

    private MessageError getMessageError(Collection<String> errorMessages) {
        ErrorType errorType = this.errorTypeMapper.mapToErrorType(this.serviceTypeDiscoveryService.getServiceType(), MessageErrorCode.FORMAT_ERROR.getCode());
        TppMessageInformation[] tppMessages = (TppMessageInformation[])errorMessages.stream().map(e -> TppMessageInformation.of(MessageErrorCode.FORMAT_ERROR, e)).toArray(TppMessageInformation[]::new);
        return new MessageError(errorType, tppMessages);
    }

    @ConstructorProperties(value={"serviceTypeDiscoveryService", "errorTypeMapper", "errorMapperContainer", "objectMapper"})
    public ErrorBuildingService(ServiceTypeDiscoveryService serviceTypeDiscoveryService, ServiceTypeToErrorTypeMapper errorTypeMapper, ErrorMapperContainer errorMapperContainer, ObjectMapper objectMapper) {
        this.serviceTypeDiscoveryService = serviceTypeDiscoveryService;
        this.errorTypeMapper = errorTypeMapper;
        this.errorMapperContainer = errorMapperContainer;
        this.objectMapper = objectMapper;
    }
}

