/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.web.mapper;

import com.fasterxml.jackson.databind.ObjectMapper;
import de.adorsys.psd2.model.BulkPaymentInitiationJson;
import de.adorsys.psd2.model.DayOfExecution;
import de.adorsys.psd2.model.ExecutionRule;
import de.adorsys.psd2.model.FrequencyCode;
import de.adorsys.psd2.model.PaymentInitiationJson;
import de.adorsys.psd2.model.PeriodicPaymentInitiationJson;
import de.adorsys.psd2.model.PeriodicPaymentInitiationXmlPart2StandingorderTypeJson;
import de.adorsys.psd2.xs2a.component.JsonConverter;
import de.adorsys.psd2.xs2a.core.pis.PisDayOfExecution;
import de.adorsys.psd2.xs2a.core.pis.PisExecutionRule;
import de.adorsys.psd2.xs2a.core.profile.AccountReference;
import de.adorsys.psd2.xs2a.core.profile.PaymentType;
import de.adorsys.psd2.xs2a.domain.code.Xs2aFrequencyCode;
import de.adorsys.psd2.xs2a.domain.code.Xs2aPurposeCode;
import de.adorsys.psd2.xs2a.domain.pis.BulkPayment;
import de.adorsys.psd2.xs2a.domain.pis.PaymentInitiationParameters;
import de.adorsys.psd2.xs2a.domain.pis.PeriodicPayment;
import de.adorsys.psd2.xs2a.domain.pis.Remittance;
import de.adorsys.psd2.xs2a.domain.pis.SinglePayment;
import de.adorsys.psd2.xs2a.service.mapper.AccountModelMapper;
import de.adorsys.psd2.xs2a.service.mapper.AmountModelMapper;
import de.adorsys.psd2.xs2a.service.validator.ValueValidatorService;
import java.beans.ConstructorProperties;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.time.LocalDate;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class PaymentModelMapperXs2a {
    private static final Logger log = LoggerFactory.getLogger(PaymentModelMapperXs2a.class);
    private final ObjectMapper mapper;
    private final ValueValidatorService validationService;
    private final AccountModelMapper accountModelMapper;
    private final HttpServletRequest httpServletRequest;
    private final AmountModelMapper amountModelMapper;
    private final JsonConverter jsonConverter;

    public Object mapToXs2aPayment(Object payment, PaymentInitiationParameters requestParameters) {
        if (requestParameters.getPaymentType() == PaymentType.SINGLE) {
            return this.mapToXs2aSinglePayment(this.validatePayment(payment, PaymentInitiationJson.class));
        }
        if (requestParameters.getPaymentType() == PaymentType.PERIODIC) {
            return this.mapToXs2aPeriodicPayment(this.validatePayment(payment, PeriodicPaymentInitiationJson.class));
        }
        return this.mapToXs2aBulkPayment(this.validatePayment(payment, BulkPaymentInitiationJson.class));
    }

    public Object mapToXs2aRawPayment(PaymentInitiationParameters requestParameters, Object xmlSct, PeriodicPaymentInitiationXmlPart2StandingorderTypeJson jsonStandingOrderType) {
        if (requestParameters.getPaymentType() == PaymentType.PERIODIC) {
            return this.buildPeriodicBinaryBodyData(xmlSct, jsonStandingOrderType);
        }
        return this.buildBinaryBodyData(this.httpServletRequest);
    }

    public Object mapToXs2aRawPayment(String payment) {
        return payment.getBytes();
    }

    private <R> R validatePayment(Object payment, Class<R> clazz) {
        Object result = this.mapper.convertValue(payment, clazz);
        this.validationService.validate(result, new Class[0]);
        return (R)result;
    }

    private SinglePayment mapToXs2aSinglePayment(PaymentInitiationJson paymentRequest) {
        SinglePayment payment = new SinglePayment();
        payment.setEndToEndIdentification(paymentRequest.getEndToEndIdentification());
        payment.setDebtorAccount(this.mapToXs2aAccountReference(paymentRequest.getDebtorAccount()));
        payment.setUltimateDebtor("NOT SUPPORTED");
        payment.setInstructedAmount(this.amountModelMapper.mapToXs2aAmount(paymentRequest.getInstructedAmount()));
        payment.setCreditorAccount(this.mapToXs2aAccountReference(paymentRequest.getCreditorAccount()));
        payment.setCreditorAgent(paymentRequest.getCreditorAgent());
        payment.setCreditorName(paymentRequest.getCreditorName());
        payment.setCreditorAddress(this.accountModelMapper.mapToXs2aAddress(paymentRequest.getCreditorAddress()));
        payment.setUltimateCreditor(paymentRequest.getCreditorName());
        payment.setPurposeCode(new Xs2aPurposeCode("N/A"));
        payment.setRemittanceInformationUnstructured(paymentRequest.getRemittanceInformationUnstructured());
        payment.setRemittanceInformationStructured(new Remittance());
        payment.setRequestedExecutionDate(paymentRequest.getRequestedExecutionDate());
        return payment;
    }

    private AccountReference mapToXs2aAccountReference(Object reference12) {
        return (AccountReference)this.mapper.convertValue(reference12, AccountReference.class);
    }

    private PeriodicPayment mapToXs2aPeriodicPayment(PeriodicPaymentInitiationJson paymentRequest) {
        PeriodicPayment payment = new PeriodicPayment();
        payment.setEndToEndIdentification(paymentRequest.getEndToEndIdentification());
        payment.setDebtorAccount(this.mapToXs2aAccountReference(paymentRequest.getDebtorAccount()));
        payment.setUltimateDebtor("NOT SUPPORTED");
        payment.setInstructedAmount(this.amountModelMapper.mapToXs2aAmount(paymentRequest.getInstructedAmount()));
        payment.setCreditorAccount(this.mapToXs2aAccountReference(paymentRequest.getCreditorAccount()));
        payment.setCreditorAgent(paymentRequest.getCreditorAgent());
        payment.setCreditorName(paymentRequest.getCreditorName());
        payment.setCreditorAddress(this.accountModelMapper.mapToXs2aAddress(paymentRequest.getCreditorAddress()));
        payment.setUltimateCreditor(paymentRequest.getCreditorName());
        payment.setPurposeCode(new Xs2aPurposeCode("N/A"));
        payment.setRemittanceInformationUnstructured(paymentRequest.getRemittanceInformationUnstructured());
        payment.setRemittanceInformationStructured(new Remittance());
        payment.setRequestedExecutionDate(LocalDate.now());
        payment.setRequestedExecutionTime(OffsetDateTime.now().plusHours(1L));
        payment.setStartDate(paymentRequest.getStartDate());
        payment.setExecutionRule(this.mapToPisExecutionRule(paymentRequest.getExecutionRule()).orElse(null));
        payment.setEndDate(paymentRequest.getEndDate());
        payment.setFrequency(this.mapToXs2aFrequencyCode(paymentRequest.getFrequency()));
        payment.setDayOfExecution(this.mapToPisDayOfExecution(paymentRequest.getDayOfExecution()).orElse(null));
        return payment;
    }

    private Optional<PisDayOfExecution> mapToPisDayOfExecution(DayOfExecution dayOfExecution) {
        return Optional.ofNullable(dayOfExecution).map(DayOfExecution::toString).flatMap(PisDayOfExecution::getByValue);
    }

    private Optional<PisExecutionRule> mapToPisExecutionRule(ExecutionRule rule) {
        return Optional.ofNullable(rule).map(ExecutionRule::toString).flatMap(PisExecutionRule::getByValue);
    }

    private Xs2aFrequencyCode mapToXs2aFrequencyCode(FrequencyCode frequency) {
        return Xs2aFrequencyCode.valueOf(frequency.name());
    }

    private BulkPayment mapToXs2aBulkPayment(BulkPaymentInitiationJson paymentRequest) {
        BulkPayment bulkPayment = new BulkPayment();
        bulkPayment.setBatchBookingPreferred(paymentRequest.getBatchBookingPreferred());
        bulkPayment.setDebtorAccount(this.mapToXs2aAccountReference(paymentRequest.getDebtorAccount()));
        bulkPayment.setRequestedExecutionDate(paymentRequest.getRequestedExecutionDate());
        bulkPayment.setRequestedExecutionTime(paymentRequest.getRequestedExecutionTime());
        bulkPayment.setPayments(this.mapBulkPaymentToSinglePayments(paymentRequest));
        return bulkPayment;
    }

    private List<SinglePayment> mapBulkPaymentToSinglePayments(BulkPaymentInitiationJson paymentRequest) {
        return paymentRequest.getPayments().stream().map(p -> {
            SinglePayment payment = new SinglePayment();
            payment.setDebtorAccount(this.mapToXs2aAccountReference(paymentRequest.getDebtorAccount()));
            payment.setRequestedExecutionDate(paymentRequest.getRequestedExecutionDate());
            payment.setEndToEndIdentification(p.getEndToEndIdentification());
            payment.setUltimateDebtor("NOT SUPPORTED");
            payment.setInstructedAmount(this.amountModelMapper.mapToXs2aAmount(p.getInstructedAmount()));
            payment.setCreditorAccount(this.mapToXs2aAccountReference(p.getCreditorAccount()));
            payment.setCreditorAgent(p.getCreditorAgent());
            payment.setCreditorName(p.getCreditorName());
            payment.setCreditorAddress(this.accountModelMapper.mapToXs2aAddress(p.getCreditorAddress()));
            payment.setUltimateCreditor(null);
            payment.setPurposeCode(new Xs2aPurposeCode(null));
            payment.setRemittanceInformationUnstructured(p.getRemittanceInformationUnstructured());
            payment.setRemittanceInformationStructured(new Remittance());
            payment.setRequestedExecutionTime(paymentRequest.getRequestedExecutionTime());
            return payment;
        }).collect(Collectors.toList());
    }

    private byte[] buildBinaryBodyData(HttpServletRequest httpServletRequest) {
        try {
            return IOUtils.toByteArray((InputStream)httpServletRequest.getInputStream());
        }
        catch (IOException e) {
            log.warn("Cannot deserialize httpServletRequest body!", (Throwable)e);
            return null;
        }
    }

    private byte[] buildPeriodicBinaryBodyData(Object xmlPart, PeriodicPaymentInitiationXmlPart2StandingorderTypeJson jsonPart) {
        Optional<String> serialisedJsonPart = this.jsonConverter.toJson(jsonPart);
        if (xmlPart == null || !serialisedJsonPart.isPresent()) {
            throw new IllegalArgumentException("Invalid body of the multipart request!");
        }
        String body = xmlPart + "\n" + serialisedJsonPart.get();
        return body.getBytes(Charset.forName("UTF-8"));
    }

    @ConstructorProperties(value={"mapper", "validationService", "accountModelMapper", "httpServletRequest", "amountModelMapper", "jsonConverter"})
    public PaymentModelMapperXs2a(ObjectMapper mapper, ValueValidatorService validationService, AccountModelMapper accountModelMapper, HttpServletRequest httpServletRequest, AmountModelMapper amountModelMapper, JsonConverter jsonConverter) {
        this.mapper = mapper;
        this.validationService = validationService;
        this.accountModelMapper = accountModelMapper;
        this.httpServletRequest = httpServletRequest;
        this.amountModelMapper = amountModelMapper;
        this.jsonConverter = jsonConverter;
    }
}

