/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.web.mapper;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import de.adorsys.psd2.xs2a.domain.Links;
import java.beans.ConstructorProperties;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class HrefLinkMapper {
    private static final Logger log = LoggerFactory.getLogger(HrefLinkMapper.class);
    private static final String HREF = "href";
    private final ObjectMapper mapper;

    public Map<String, Map<String, String>> mapToLinksMap(Links links) {
        if (links == null) {
            return null;
        }
        Map linksMap = (Map)this.mapper.convertValue((Object)links, (TypeReference)new TypeReference<Map<String, String>>(){});
        return linksMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> Collections.singletonMap(HREF, e.getValue())));
    }

    public Map<String, Map<String, String>> mapToLinksMap(String name, String link) {
        return Optional.ofNullable(link).map(l -> Collections.singletonMap(name, Collections.singletonMap(HREF, l))).orElseGet(() -> Collections.singletonMap(name, null));
    }

    @ConstructorProperties(value={"mapper"})
    public HrefLinkMapper(ObjectMapper mapper) {
        this.mapper = mapper;
    }
}

