/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.web.interceptor.logging;

import de.adorsys.psd2.xs2a.component.TppLogger;
import de.adorsys.psd2.xs2a.service.TppService;
import java.beans.ConstructorProperties;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.stereotype.Component;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;

@Component
public class FundsConfirmationLoggingInterceptor
extends HandlerInterceptorAdapter {
    private final TppService tppService;

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) {
        TppLogger.logRequest().withParam("TPP ID", this.tppService.getTppId()).withParam("TPP IP", request.getRemoteAddr()).withParam("X-Request-ID", request.getHeader("X-Request-ID")).withParam("URI", request.getRequestURI()).perform();
        return true;
    }

    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) {
        TppLogger.logResponse().withParam("TPP ID", this.tppService.getTppId()).withParam("X-Request-ID", response.getHeader("X-Request-ID")).withParam("Status", String.valueOf(response.getStatus())).perform();
    }

    @ConstructorProperties(value={"tppService"})
    public FundsConfirmationLoggingInterceptor(TppService tppService) {
        this.tppService = tppService;
    }
}

