/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.web.controller;

import de.adorsys.psd2.api.AccountApi;
import de.adorsys.psd2.xs2a.core.ais.BookingStatus;
import de.adorsys.psd2.xs2a.domain.ResponseObject;
import de.adorsys.psd2.xs2a.domain.Transactions;
import de.adorsys.psd2.xs2a.domain.account.Xs2aAccountDetailsHolder;
import de.adorsys.psd2.xs2a.domain.account.Xs2aAccountListHolder;
import de.adorsys.psd2.xs2a.domain.account.Xs2aBalancesReport;
import de.adorsys.psd2.xs2a.domain.account.Xs2aTransactionsReport;
import de.adorsys.psd2.xs2a.service.AccountService;
import de.adorsys.psd2.xs2a.service.mapper.AccountModelMapper;
import de.adorsys.psd2.xs2a.service.mapper.ResponseMapper;
import de.adorsys.psd2.xs2a.service.mapper.psd2.ResponseErrorMapper;
import io.swagger.annotations.Api;
import java.beans.ConstructorProperties;
import java.time.LocalDate;
import java.util.Optional;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.BooleanUtils;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(value="v1", description="Provides access to the account information", tags={"Account Information Service (AIS)"})
public class AccountController
implements AccountApi {
    private final HttpServletRequest request;
    private final AccountService accountService;
    private final ResponseMapper responseMapper;
    private final AccountModelMapper accountModelMapper;
    private final ResponseErrorMapper responseErrorMapper;

    public ResponseEntity getAccountList(UUID xRequestID, String consentID, Boolean withBalance, String digest, String signature, byte[] tpPSignatureCertificate, String psUIPAddress, String psUIPPort, String psUAccept, String psUAcceptCharset, String psUAcceptEncoding, String psUAcceptLanguage, String psUUserAgent, String psUHttpMethod, UUID psUDeviceID, String psUGeoLocation) {
        ResponseObject<Xs2aAccountListHolder> accountList = this.accountService.getAccountList(consentID, Optional.ofNullable(withBalance).orElse(false));
        return accountList.hasError() ? this.responseErrorMapper.generateErrorResponse(accountList.getError()) : this.responseMapper.ok(accountList, this.accountModelMapper::mapToAccountList);
    }

    public ResponseEntity readAccountDetails(String accountId, UUID xRequestID, String consentID, Boolean withBalance, String digest, String signature, byte[] tpPSignatureCertificate, String psUIPAddress, String psUIPPort, String psUAccept, String psUAcceptCharset, String psUAcceptEncoding, String psUAcceptLanguage, String psUUserAgent, String psUHttpMethod, UUID psUDeviceID, String psUGeoLocation) {
        ResponseObject<Xs2aAccountDetailsHolder> accountDetails = this.accountService.getAccountDetails(consentID, accountId, Optional.ofNullable(withBalance).orElse(false));
        return accountDetails.hasError() ? this.responseErrorMapper.generateErrorResponse(accountDetails.getError()) : this.responseMapper.ok(accountDetails, this.accountModelMapper::mapToAccountDetails);
    }

    public ResponseEntity getBalances(String accountId, UUID xRequestID, String consentID, String digest, String signature, byte[] tpPSignatureCertificate, String psUIPAddress, String psUIPPort, String psUAccept, String psUAcceptCharset, String psUAcceptEncoding, String psUAcceptLanguage, String psUUserAgent, String psUHttpMethod, UUID psUDeviceID, String psUGeoLocation) {
        ResponseObject<Xs2aBalancesReport> balancesReport = this.accountService.getBalancesReport(consentID, accountId);
        return balancesReport.hasError() ? this.responseErrorMapper.generateErrorResponse(balancesReport.getError()) : this.responseMapper.ok(balancesReport, this.accountModelMapper::mapToBalance);
    }

    public ResponseEntity getTransactionList(String accountId, String bookingStatus, UUID xRequestID, String consentID, LocalDate dateFrom, LocalDate dateTo, String entryReferenceFrom, Boolean deltaList, Boolean withBalance, String digest, String signature, byte[] tpPSignatureCertificate, String psUIPAddress, String psUIPPort, String psUAccept, String psUAcceptCharset, String psUAcceptEncoding, String psUAcceptLanguage, String psUUserAgent, String psUHttpMethod, UUID psUDeviceID, String psUGeoLocation) {
        ResponseObject<Xs2aTransactionsReport> transactionsReport = this.accountService.getTransactionsReportByPeriod(consentID, accountId, this.request.getHeader("accept"), BooleanUtils.isTrue((Boolean)withBalance), dateFrom, dateTo, BookingStatus.forValue((String)bookingStatus));
        if (transactionsReport.hasError()) {
            return this.responseErrorMapper.generateErrorResponse(transactionsReport.getError());
        }
        if (transactionsReport.getBody().isResponseContentTypeJson()) {
            return this.responseMapper.ok(transactionsReport, this.accountModelMapper::mapToTransactionsResponse200Json);
        }
        return this.responseMapper.ok(transactionsReport, this.accountModelMapper::mapToTransactionsResponseRaw);
    }

    public ResponseEntity getTransactionDetails(String accountId, String resourceId, UUID xRequestID, String consentID, String digest, String signature, byte[] tpPSignatureCertificate, String psUIPAddress, String psUIPPort, String psUAccept, String psUAcceptCharset, String psUAcceptEncoding, String psUAcceptLanguage, String psUUserAgent, String psUHttpMethod, UUID psUDeviceID, String psUGeoLocation) {
        ResponseObject<Transactions> transactionDetails = this.accountService.getTransactionDetails(consentID, accountId, resourceId);
        return transactionDetails.hasError() ? this.responseErrorMapper.generateErrorResponse(transactionDetails.getError()) : this.responseMapper.ok(transactionDetails, this.accountModelMapper::mapToTransactionDetails);
    }

    @ConstructorProperties(value={"request", "accountService", "responseMapper", "accountModelMapper", "responseErrorMapper"})
    public AccountController(HttpServletRequest request, AccountService accountService, ResponseMapper responseMapper, AccountModelMapper accountModelMapper, ResponseErrorMapper responseErrorMapper) {
        this.request = request;
        this.accountService = accountService;
        this.responseMapper = responseMapper;
        this.accountModelMapper = accountModelMapper;
        this.responseErrorMapper = responseErrorMapper;
    }
}

