/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.web.aspect;

import de.adorsys.psd2.xs2a.component.JsonConverter;
import de.adorsys.psd2.xs2a.domain.ResponseObject;
import de.adorsys.psd2.xs2a.domain.account.Xs2aTransactionsReport;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.Aspect;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class TransactionReportAspect {
    private static final Logger log = LoggerFactory.getLogger(TransactionReportAspect.class);
    private final int maxNumberOfCharInTransactionJson;
    private final JsonConverter jsonConverter;

    public TransactionReportAspect(int maxNumberOfCharInTransactionJson, JsonConverter jsonConverter) {
        this.maxNumberOfCharInTransactionJson = maxNumberOfCharInTransactionJson;
        this.jsonConverter = jsonConverter;
    }

    @AfterReturning(pointcut="execution(* de.adorsys.psd2.xs2a.service.AccountService.getTransactionsReportByPeriod(..))", returning="result", argNames="result")
    public ResponseObject<Xs2aTransactionsReport> invokeGetTransactionsReportByPeriodAspect(ResponseObject<Xs2aTransactionsReport> result) {
        if (!result.hasError()) {
            Xs2aTransactionsReport report = result.getBody();
            report.setTransactionReportHuge(this.isTransactionReportHuge(report));
        }
        return result;
    }

    private boolean isTransactionReportHuge(Xs2aTransactionsReport transactionsReport) {
        String jsonReport = this.jsonConverter.toJson(transactionsReport).orElse("");
        return jsonReport.length() > this.maxNumberOfCharInTransactionJson;
    }
}

