/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.web.aspect;

import de.adorsys.psd2.aspsp.profile.service.AspspProfileService;
import de.adorsys.psd2.xs2a.core.profile.AccountReference;
import de.adorsys.psd2.xs2a.domain.Links;
import de.adorsys.psd2.xs2a.domain.ResponseObject;
import de.adorsys.psd2.xs2a.domain.Transactions;
import de.adorsys.psd2.xs2a.domain.account.Xs2aAccountDetails;
import de.adorsys.psd2.xs2a.domain.account.Xs2aAccountDetailsHolder;
import de.adorsys.psd2.xs2a.domain.account.Xs2aAccountListHolder;
import de.adorsys.psd2.xs2a.domain.account.Xs2aAccountReport;
import de.adorsys.psd2.xs2a.domain.account.Xs2aTransactionsReport;
import de.adorsys.psd2.xs2a.domain.consent.Xs2aAccountAccess;
import de.adorsys.psd2.xs2a.service.ScaApproachResolver;
import de.adorsys.psd2.xs2a.service.message.MessageService;
import de.adorsys.psd2.xs2a.web.aspect.AbstractLinkAspect;
import de.adorsys.psd2.xs2a.web.controller.AccountController;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.Aspect;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class AccountAspect
extends AbstractLinkAspect<AccountController> {
    private static final Logger log = LoggerFactory.getLogger(AccountAspect.class);

    public AccountAspect(ScaApproachResolver scaApproachResolver, MessageService messageService, AspspProfileService aspspProfileService) {
        super(scaApproachResolver, messageService, aspspProfileService);
    }

    @AfterReturning(pointcut="execution(* de.adorsys.psd2.xs2a.service.AccountService.getAccountDetails(..)) && args( consentId, accountId, withBalance)", returning="result", argNames="result,consentId,accountId,withBalance")
    public ResponseObject<Xs2aAccountDetailsHolder> getAccountDetailsAspect(ResponseObject<Xs2aAccountDetailsHolder> result, String consentId, String accountId, boolean withBalance) {
        if (!result.hasError()) {
            Xs2aAccountDetails accountDetails = result.getBody().getAccountDetails();
            accountDetails.setLinks(this.buildLinksForAccountDetails(accountDetails.getResourceId(), result.getBody().getAccountConsent().getAccess()));
            return result;
        }
        return this.enrichErrorTextMessage(result);
    }

    @AfterReturning(pointcut="execution(* de.adorsys.psd2.xs2a.service.AccountService.getAccountList(..)) && args( consentId, withBalance)", returning="result", argNames="result,consentId,withBalance")
    public ResponseObject<Xs2aAccountListHolder> getAccountDetailsListAspect(ResponseObject<Xs2aAccountListHolder> result, String consentId, boolean withBalance) {
        if (!result.hasError()) {
            List<Xs2aAccountDetails> accountDetails = result.getBody().getAccountDetails();
            this.setLinksToAccounts(accountDetails, result.getBody().getAccountConsent().getAccess());
            return result;
        }
        return this.enrichErrorTextMessage(result);
    }

    @AfterReturning(pointcut="execution(* de.adorsys.psd2.xs2a.service.AccountService.getTransactionsReportByPeriod(..)) && args( consentId, accountId, withBalance, ..)", returning="result", argNames="result,consentId,accountId,withBalance")
    public ResponseObject<Xs2aTransactionsReport> getTransactionsReportByPeriod(ResponseObject<Xs2aTransactionsReport> result, String consentId, String accountId, boolean withBalance) {
        if (!result.hasError()) {
            Xs2aTransactionsReport transactionsReport = result.getBody();
            if (transactionsReport.isTransactionReportHuge()) {
                Links links = new Links();
                links.setDownload(this.buildPath("/v1/accounts/{accountId}/transactions/download", accountId));
                transactionsReport.setLinks(links);
            } else {
                Xs2aAccountReport accountReport = transactionsReport.getAccountReport();
                accountReport.setLinks(this.buildLinksForAccountReport(accountId));
            }
            return result;
        }
        return this.enrichErrorTextMessage(result);
    }

    @AfterReturning(pointcut="execution(* de.adorsys.psd2.xs2a.service.AccountService.getTransactionDetails(..)) && args( consentID, accountId, resourceId)", returning="result", argNames="result,consentID,accountId,resourceId")
    public ResponseObject<Transactions> getTransactionDetailsAspect(ResponseObject<Transactions> result, String consentID, String accountId, String resourceId) {
        if (!result.hasError()) {
            return result;
        }
        return this.enrichErrorTextMessage(result);
    }

    private Links buildLinksForAccountReport(String accountId) {
        Links links = new Links();
        links.setAccount(this.buildPath("/v1/accounts/{accountId}", accountId));
        return links;
    }

    private void setLinksToAccounts(List<Xs2aAccountDetails> accountDetailsList, Xs2aAccountAccess xs2aAccountAccess) {
        accountDetailsList.forEach(acc -> acc.setLinks(this.buildLinksForAccountDetails(acc.getResourceId(), xs2aAccountAccess)));
    }

    private Links buildLinksForAccountDetails(String accountId, Xs2aAccountAccess xs2aAccountAccess) {
        Links links = new Links();
        if (this.isValidAccountByAccess(accountId, xs2aAccountAccess.getBalances())) {
            links.setBalances(this.buildPath("/v1/accounts/{accountId}/balances", accountId));
        }
        if (this.isValidAccountByAccess(accountId, xs2aAccountAccess.getTransactions())) {
            links.setTransactions(this.buildPath("/v1/accounts/{accountId}/transactions", accountId));
        }
        return links;
    }

    private boolean isValidAccountByAccess(String accountId, List<AccountReference> allowedAccountData) {
        return CollectionUtils.isNotEmpty(allowedAccountData) && allowedAccountData.stream().anyMatch(a -> accountId.equals(a.getResourceId()));
    }
}

