/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.web.aspect;

import de.adorsys.psd2.aspsp.profile.service.AspspProfileService;
import de.adorsys.psd2.xs2a.domain.ResponseObject;
import de.adorsys.psd2.xs2a.domain.TppMessageInformation;
import de.adorsys.psd2.xs2a.exception.MessageError;
import de.adorsys.psd2.xs2a.service.ScaApproachResolver;
import de.adorsys.psd2.xs2a.service.message.MessageService;
import java.beans.ConstructorProperties;
import java.lang.reflect.ParameterizedType;
import java.util.Collections;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.hateoas.mvc.ControllerLinkBuilder;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.web.util.UriComponentsBuilder;

@Component
public abstract class AbstractLinkAspect<T> {
    private static final Logger log = LoggerFactory.getLogger(AbstractLinkAspect.class);
    protected final ScaApproachResolver scaApproachResolver;
    private final MessageService messageService;
    private final AspspProfileService aspspProfileService;

    protected <B> boolean hasError(ResponseEntity<B> target) {
        Optional<Object> body = Optional.ofNullable(target.getBody());
        return body.isPresent() && body.get().getClass().isAssignableFrom(MessageError.class);
    }

    <R> ResponseObject<R> enrichErrorTextMessage(ResponseObject<R> response) {
        MessageError error = response.getError();
        TppMessageInformation tppMessage = error.getTppMessage();
        if (StringUtils.isBlank((CharSequence)tppMessage.getText())) {
            tppMessage.setText(this.messageService.getMessage(tppMessage.getMessageErrorCode().name()));
            error.setTppMessages(Collections.singleton(tppMessage));
        }
        return ResponseObject.builder().fail(error).build();
    }

    String buildPath(String path, Object ... params) {
        UriComponentsBuilder uriComponentsBuilder = this.aspspProfileService.getAspspSettings().isForceXs2aBaseUrl() ? UriComponentsBuilder.fromHttpUrl((String)this.aspspProfileService.getAspspSettings().getXs2aBaseUrl()) : UriComponentsBuilder.fromHttpUrl((String)ControllerLinkBuilder.linkTo(this.getControllerClass()).toString());
        return uriComponentsBuilder.path(path).buildAndExpand(params).toUriString();
    }

    private Class<T> getControllerClass() {
        try {
            String className = ((ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments()[0].getTypeName();
            return Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException("Class isn't parametrized with generic type! Use <>");
        }
    }

    @ConstructorProperties(value={"scaApproachResolver", "messageService", "aspspProfileService"})
    public AbstractLinkAspect(ScaApproachResolver scaApproachResolver, MessageService messageService, AspspProfileService aspspProfileService) {
        this.scaApproachResolver = scaApproachResolver;
        this.messageService = messageService;
        this.aspspProfileService = aspspProfileService;
    }
}

