/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service.validator.tpp;

import de.adorsys.psd2.xs2a.core.tpp.TppInfo;
import de.adorsys.psd2.xs2a.domain.MessageErrorCode;
import de.adorsys.psd2.xs2a.domain.TppMessageInformation;
import de.adorsys.psd2.xs2a.service.RequestProviderService;
import de.adorsys.psd2.xs2a.service.mapper.psd2.ErrorType;
import de.adorsys.psd2.xs2a.service.validator.ValidationResult;
import de.adorsys.psd2.xs2a.service.validator.tpp.TppInfoCheckerService;
import java.beans.ConstructorProperties;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class PisTppInfoValidator {
    private static final Logger log = LoggerFactory.getLogger(PisTppInfoValidator.class);
    private final TppInfoCheckerService tppInfoCheckerService;
    private final RequestProviderService requestProviderService;

    public ValidationResult validateTpp(@Nullable TppInfo tppInfoInPayment) {
        if (this.tppInfoCheckerService.differsFromTppInRequest(tppInfoInPayment)) {
            log.info("X-Request-ID: [{}]. TPP validation has failed: TPP in payment doesn't match the TPP in request", (Object)this.requestProviderService.getRequestId());
            return ValidationResult.invalid(ErrorType.PIS_401, TppMessageInformation.of(MessageErrorCode.UNAUTHORIZED, "TPP certificate doesn\u2019t match the initial request"));
        }
        return ValidationResult.valid();
    }

    @ConstructorProperties(value={"tppInfoCheckerService", "requestProviderService"})
    public PisTppInfoValidator(TppInfoCheckerService tppInfoCheckerService, RequestProviderService requestProviderService) {
        this.tppInfoCheckerService = tppInfoCheckerService;
        this.requestProviderService = requestProviderService;
    }
}

