/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service.validator.pis;

import de.adorsys.psd2.xs2a.core.tpp.TppInfo;
import de.adorsys.psd2.xs2a.service.validator.BusinessValidator;
import de.adorsys.psd2.xs2a.service.validator.TppInfoProvider;
import de.adorsys.psd2.xs2a.service.validator.ValidationResult;
import de.adorsys.psd2.xs2a.service.validator.tpp.PisTppInfoValidator;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public abstract class AbstractPisTppValidator<T extends TppInfoProvider>
implements BusinessValidator<T> {
    private PisTppInfoValidator pisTppInfoValidator;

    @Override
    @NotNull
    public ValidationResult validate(@NotNull T object) {
        TppInfo tppInfoInPayment = object.getTppInfo();
        ValidationResult tppValidationResult = this.pisTppInfoValidator.validateTpp(tppInfoInPayment);
        if (tppValidationResult.isNotValid()) {
            return tppValidationResult;
        }
        return this.executeBusinessValidation(object);
    }

    protected abstract ValidationResult executeBusinessValidation(T var1);

    @Autowired
    public void setPisTppInfoValidator(PisTppInfoValidator pisTppInfoValidator) {
        this.pisTppInfoValidator = pisTppInfoValidator;
    }
}

