/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service.payment;

import de.adorsys.psd2.consent.api.pis.proto.PisCommonPaymentResponse;
import de.adorsys.psd2.xs2a.core.consent.AspspConsentData;
import de.adorsys.psd2.xs2a.core.pis.TransactionStatus;
import de.adorsys.psd2.xs2a.domain.pis.CommonPayment;
import de.adorsys.psd2.xs2a.domain.pis.ReadPaymentStatusResponse;
import de.adorsys.psd2.xs2a.service.consent.PisAspspDataService;
import de.adorsys.psd2.xs2a.service.mapper.consent.CmsToXs2aPaymentMapper;
import de.adorsys.psd2.xs2a.service.mapper.psd2.ServiceType;
import de.adorsys.psd2.xs2a.service.mapper.spi_xs2a_mappers.SpiErrorMapper;
import de.adorsys.psd2.xs2a.service.mapper.spi_xs2a_mappers.Xs2aToSpiPaymentInfoMapper;
import de.adorsys.psd2.xs2a.spi.domain.SpiContextData;
import de.adorsys.psd2.xs2a.spi.domain.payment.SpiPaymentInfo;
import de.adorsys.psd2.xs2a.spi.domain.response.SpiResponse;
import de.adorsys.psd2.xs2a.spi.service.CommonPaymentSpi;
import java.beans.ConstructorProperties;
import org.springframework.stereotype.Service;

@Service
public class ReadCommonPaymentStatusService {
    private final PisAspspDataService pisAspspDataService;
    private final CommonPaymentSpi commonPaymentSpi;
    private final SpiErrorMapper spiErrorMapper;
    private final Xs2aToSpiPaymentInfoMapper xs2aToSpiPaymentInfoMapper;
    private final CmsToXs2aPaymentMapper cmsToXs2aPaymentMapper;

    public ReadPaymentStatusResponse readPaymentStatus(PisCommonPaymentResponse pisCommonPaymentResponse, SpiContextData spiContextData, AspspConsentData aspspConsentData) {
        CommonPayment commonPayment = this.cmsToXs2aPaymentMapper.mapToXs2aCommonPayment(pisCommonPaymentResponse);
        SpiPaymentInfo request = this.xs2aToSpiPaymentInfoMapper.mapToSpiPaymentInfo(commonPayment);
        SpiResponse spiResponse = this.commonPaymentSpi.getPaymentStatusById(spiContextData, request, aspspConsentData);
        this.pisAspspDataService.updateAspspConsentData(spiResponse.getAspspConsentData());
        if (spiResponse.hasError()) {
            return new ReadPaymentStatusResponse(this.spiErrorMapper.mapToErrorHolder(spiResponse, ServiceType.PIS));
        }
        return new ReadPaymentStatusResponse((TransactionStatus)spiResponse.getPayload());
    }

    @ConstructorProperties(value={"pisAspspDataService", "commonPaymentSpi", "spiErrorMapper", "xs2aToSpiPaymentInfoMapper", "cmsToXs2aPaymentMapper"})
    public ReadCommonPaymentStatusService(PisAspspDataService pisAspspDataService, CommonPaymentSpi commonPaymentSpi, SpiErrorMapper spiErrorMapper, Xs2aToSpiPaymentInfoMapper xs2aToSpiPaymentInfoMapper, CmsToXs2aPaymentMapper cmsToXs2aPaymentMapper) {
        this.pisAspspDataService = pisAspspDataService;
        this.commonPaymentSpi = commonPaymentSpi;
        this.spiErrorMapper = spiErrorMapper;
        this.xs2aToSpiPaymentInfoMapper = xs2aToSpiPaymentInfoMapper;
        this.cmsToXs2aPaymentMapper = cmsToXs2aPaymentMapper;
    }
}

