/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.config;

import com.fasterxml.jackson.databind.ObjectMapper;
import de.adorsys.psd2.consent.api.service.TppStopListService;
import de.adorsys.psd2.xs2a.component.PaymentTypeEnumConverter;
import de.adorsys.psd2.xs2a.config.CorsConfigurationProperties;
import de.adorsys.psd2.xs2a.config.Xs2aEndpointPathConstant;
import de.adorsys.psd2.xs2a.domain.ScaApproachHolder;
import de.adorsys.psd2.xs2a.service.TppService;
import de.adorsys.psd2.xs2a.service.discovery.ServiceTypeDiscoveryService;
import de.adorsys.psd2.xs2a.service.mapper.psd2.ErrorMapperContainer;
import de.adorsys.psd2.xs2a.service.mapper.psd2.ServiceTypeToErrorTypeMapper;
import de.adorsys.psd2.xs2a.service.validator.RequestValidatorService;
import de.adorsys.psd2.xs2a.service.validator.tpp.TppInfoHolder;
import de.adorsys.psd2.xs2a.web.interceptor.HandlerInterceptor;
import de.adorsys.psd2.xs2a.web.interceptor.HeaderValidationInterceptor;
import de.adorsys.psd2.xs2a.web.interceptor.logging.AccountLoggingInterceptor;
import de.adorsys.psd2.xs2a.web.interceptor.logging.ConsentLoggingInterceptor;
import de.adorsys.psd2.xs2a.web.interceptor.logging.FundsConfirmationLoggingInterceptor;
import de.adorsys.psd2.xs2a.web.interceptor.logging.PaymentLoggingInterceptor;
import de.adorsys.psd2.xs2a.web.interceptor.logging.SigningBasketLoggingInterceptor;
import de.adorsys.psd2.xs2a.web.interceptor.tpp.TppStopListInterceptor;
import java.beans.ConstructorProperties;
import java.util.List;
import javax.validation.Validation;
import javax.validation.Validator;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.EnableAspectJAutoProxy;
import org.springframework.core.convert.converter.GenericConverter;
import org.springframework.format.FormatterRegistry;
import org.springframework.web.context.annotation.RequestScope;
import org.springframework.web.servlet.config.annotation.CorsRegistry;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.PathMatchConfigurer;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurerAdapter;

@Configuration
@EnableAspectJAutoProxy(proxyTargetClass=true)
public class WebConfig
extends WebMvcConfigurerAdapter {
    @Value(value="${application.ais.transaction.max-length}")
    private int maxNumberOfCharInTransactionJson;
    @Qualifier(value="xs2aCorsConfigProperties")
    private final CorsConfigurationProperties corsConfigurationProperties;
    private final TppService tppService;
    private final TppStopListService tppStopListService;
    private final ServiceTypeDiscoveryService serviceTypeDiscoveryService;
    private final ServiceTypeToErrorTypeMapper errorTypeMapper;
    private final ErrorMapperContainer errorMapperContainer;
    private final ObjectMapper objectMapper;
    private final HeaderValidationInterceptor headerValidationInterceptor;

    public void configurePathMatch(PathMatchConfigurer configurer) {
        configurer.setUseSuffixPatternMatch(Boolean.valueOf(false));
    }

    @Bean
    public RequestValidatorService requestValidatorService() {
        return new RequestValidatorService();
    }

    public void addInterceptors(InterceptorRegistry registry) {
        registry.addInterceptor((org.springframework.web.servlet.HandlerInterceptor)new AccountLoggingInterceptor(this.tppService)).addPathPatterns(new String[]{"/v1/accounts/**"});
        registry.addInterceptor((org.springframework.web.servlet.HandlerInterceptor)new ConsentLoggingInterceptor(this.tppService)).addPathPatterns(new String[]{"/v1/consents/**"});
        registry.addInterceptor((org.springframework.web.servlet.HandlerInterceptor)new FundsConfirmationLoggingInterceptor(this.tppService)).addPathPatterns(new String[]{"/v1/funds-confirmations/**"});
        registry.addInterceptor((org.springframework.web.servlet.HandlerInterceptor)new PaymentLoggingInterceptor(this.tppService)).addPathPatterns(new String[]{"/v1/payments/**", "/v1/bulk-payments/**", "/v1/periodic-payments/**"});
        registry.addInterceptor((org.springframework.web.servlet.HandlerInterceptor)new SigningBasketLoggingInterceptor(this.tppService)).addPathPatterns(new String[]{"/v1/signing-baskets/**"});
        registry.addInterceptor((org.springframework.web.servlet.HandlerInterceptor)new TppStopListInterceptor(this.errorMapperContainer, this.tppService, this.tppStopListService, this.serviceTypeDiscoveryService, this.errorTypeMapper, this.objectMapper)).addPathPatterns(Xs2aEndpointPathConstant.getAllXs2aEndpointPaths());
        registry.addInterceptor((org.springframework.web.servlet.HandlerInterceptor)this.headerValidationInterceptor).addPathPatterns(Xs2aEndpointPathConstant.getAllXs2aEndpointPaths());
        registry.addInterceptor((org.springframework.web.servlet.HandlerInterceptor)new HandlerInterceptor(this.requestValidatorService(), this.serviceTypeDiscoveryService, this.errorTypeMapper, this.errorMapperContainer, this.objectMapper)).addPathPatterns(Xs2aEndpointPathConstant.getAllXs2aEndpointPaths());
    }

    @Bean
    public int maxNumberOfCharInTransactionJson() {
        return this.maxNumberOfCharInTransactionJson;
    }

    @Bean
    public Validator validator() {
        return Validation.buildDefaultValidatorFactory().getValidator();
    }

    public void addCorsMappings(CorsRegistry registry) {
        registry.addMapping("/v1/**").allowCredentials(this.corsConfigurationProperties.getAllowCredentials().booleanValue()).allowedOrigins(this.getTargetParameters(this.corsConfigurationProperties.getAllowedOrigins())).allowedHeaders(this.getTargetParameters(this.corsConfigurationProperties.getAllowedHeaders())).allowedMethods(this.getTargetParameters(this.corsConfigurationProperties.getAllowedMethods())).maxAge(this.corsConfigurationProperties.getMaxAge());
    }

    private String[] getTargetParameters(List<String> targetParameters) {
        return targetParameters.toArray(new String[0]);
    }

    @Bean
    @RequestScope
    public TppInfoHolder getTppInfoHolder() {
        return new TppInfoHolder();
    }

    @Bean
    @RequestScope
    public ScaApproachHolder getScaApproachHolder() {
        return new ScaApproachHolder();
    }

    public void addFormatters(FormatterRegistry registry) {
        registry.addConverter((GenericConverter)new PaymentTypeEnumConverter());
    }

    @ConstructorProperties(value={"corsConfigurationProperties", "tppService", "tppStopListService", "serviceTypeDiscoveryService", "errorTypeMapper", "errorMapperContainer", "objectMapper", "headerValidationInterceptor"})
    public WebConfig(CorsConfigurationProperties corsConfigurationProperties, TppService tppService, TppStopListService tppStopListService, ServiceTypeDiscoveryService serviceTypeDiscoveryService, ServiceTypeToErrorTypeMapper errorTypeMapper, ErrorMapperContainer errorMapperContainer, ObjectMapper objectMapper, HeaderValidationInterceptor headerValidationInterceptor) {
        this.corsConfigurationProperties = corsConfigurationProperties;
        this.tppService = tppService;
        this.tppStopListService = tppStopListService;
        this.serviceTypeDiscoveryService = serviceTypeDiscoveryService;
        this.errorTypeMapper = errorTypeMapper;
        this.errorMapperContainer = errorMapperContainer;
        this.objectMapper = objectMapper;
        this.headerValidationInterceptor = headerValidationInterceptor;
    }
}

