/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.web.validator.body.raw;

import com.fasterxml.jackson.databind.ObjectMapper;
import de.adorsys.psd2.xs2a.component.JsonConverter;
import de.adorsys.psd2.xs2a.domain.MessageErrorCode;
import de.adorsys.psd2.xs2a.domain.TppMessageInformation;
import de.adorsys.psd2.xs2a.exception.MessageError;
import de.adorsys.psd2.xs2a.web.converter.LocalDateConverter;
import de.adorsys.psd2.xs2a.web.validator.ErrorBuildingService;
import de.adorsys.psd2.xs2a.web.validator.body.raw.AbstractRawBodyValidatorImpl;
import de.adorsys.psd2.xs2a.web.validator.body.raw.PaymentRawBodyValidator;
import de.adorsys.psd2.xs2a.web.validator.constants.Xs2aRequestBodyDateFields;
import javax.servlet.http.HttpServletRequest;
import org.jetbrains.annotations.NotNull;
import org.springframework.stereotype.Component;

@Component
public class PaymentRawBodyValidatorImpl
extends AbstractRawBodyValidatorImpl
implements PaymentRawBodyValidator {
    private static final String DAY_OF_EXECUTION_FIELD_NAME = "dayOfExecution";
    private static final String DAY_OF_MONTH_REGEX = "(0?[1-9]|[12]\\d|3[01])";
    private static final String DAY_OF_EXECUTION_WRONG_VALUE_ERROR = "Value 'dayOfExecution' should be a number of day in month";

    protected PaymentRawBodyValidatorImpl(ErrorBuildingService errorBuildingService, ObjectMapper objectMapper, JsonConverter jsonConverter, LocalDateConverter localDateConverter) {
        super(errorBuildingService, objectMapper, jsonConverter, localDateConverter);
    }

    @Override
    public void validate(HttpServletRequest request, MessageError messageError) {
        String dayOfExecution = this.extractField(request, DAY_OF_EXECUTION_FIELD_NAME, messageError);
        this.validateDayOfExecutionValue(dayOfExecution, messageError);
        this.validateRawDataDates(request, Xs2aRequestBodyDateFields.PAYMENT_DATE_FIELDS.getDateFields(), messageError);
    }

    private void validateDayOfExecutionValue(String value, MessageError messageError) {
        if (value == null) {
            return;
        }
        if (!this.isNumberADayOfMonth(value)) {
            this.errorBuildingService.enrichMessageError(messageError, TppMessageInformation.of(MessageErrorCode.FORMAT_ERROR, DAY_OF_EXECUTION_WRONG_VALUE_ERROR));
        }
    }

    private boolean isNumberADayOfMonth(@NotNull String value) {
        return value.matches(DAY_OF_MONTH_REGEX);
    }
}

