/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.web.validator.body.raw;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import de.adorsys.psd2.xs2a.component.JsonConverter;
import de.adorsys.psd2.xs2a.exception.MessageError;
import de.adorsys.psd2.xs2a.web.converter.LocalDateConverter;
import de.adorsys.psd2.xs2a.web.validator.ErrorBuildingService;
import de.adorsys.psd2.xs2a.web.validator.constants.Xs2aBodyDateFormatter;
import de.adorsys.psd2.xs2a.web.validator.constants.Xs2aRequestBodyDateField;
import java.io.IOException;
import java.io.InputStream;
import java.time.format.DateTimeParseException;
import java.util.EnumSet;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;

public class AbstractRawBodyValidatorImpl {
    private static final String ERROR_TEXT_ISO_DATE_FORMAT = "Wrong format for '%s': value should be %s '%s' format.";
    private static final String BODY_DESERIALIZATION_ERROR = "Cannot deserialize the request body";
    protected ErrorBuildingService errorBuildingService;
    protected ObjectMapper objectMapper;
    protected JsonConverter jsonConverter;
    protected LocalDateConverter localDateConverter;

    protected AbstractRawBodyValidatorImpl(ErrorBuildingService errorBuildingService, ObjectMapper objectMapper, JsonConverter jsonConverter, LocalDateConverter localDateConverter) {
        this.errorBuildingService = errorBuildingService;
        this.objectMapper = objectMapper;
        this.jsonConverter = jsonConverter;
        this.localDateConverter = localDateConverter;
    }

    protected void validateRawDataDates(HttpServletRequest request, EnumSet<Xs2aRequestBodyDateField> fields, MessageError messageError) {
        for (Xs2aRequestBodyDateField field : fields) {
            Optional.ofNullable(this.extractField(request, field.getFieldName(), messageError)).ifPresent(date -> this.convert(field.getFieldName(), (String)date, field.getFormatter(), messageError));
        }
    }

    private void convert(String key, String value, Xs2aBodyDateFormatter formatter, MessageError messageError) {
        try {
            this.localDateConverter.convert(value, formatter.getFormatter());
        }
        catch (DateTimeParseException ex) {
            this.errorBuildingService.enrichMessageError(messageError, String.format(ERROR_TEXT_ISO_DATE_FORMAT, key, formatter.name(), formatter.getPattern()));
        }
    }

    protected String extractField(HttpServletRequest request, String fieldName, MessageError messageError) {
        Optional<Object> fieldOptional = Optional.empty();
        try {
            fieldOptional = this.jsonConverter.toJsonField((InputStream)request.getInputStream(), fieldName, new TypeReference<String>(){});
        }
        catch (IOException e) {
            this.errorBuildingService.enrichMessageError(messageError, BODY_DESERIALIZATION_ERROR);
        }
        return fieldOptional.orElse(null);
    }
}

