/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.web.validator.body.payment.type;

import com.fasterxml.jackson.databind.ObjectMapper;
import de.adorsys.psd2.xs2a.core.profile.PaymentType;
import de.adorsys.psd2.xs2a.domain.MessageErrorCode;
import de.adorsys.psd2.xs2a.domain.TppMessageInformation;
import de.adorsys.psd2.xs2a.domain.pis.BulkPayment;
import de.adorsys.psd2.xs2a.domain.pis.SinglePayment;
import de.adorsys.psd2.xs2a.exception.MessageError;
import de.adorsys.psd2.xs2a.web.validator.ErrorBuildingService;
import de.adorsys.psd2.xs2a.web.validator.body.payment.mapper.PaymentMapper;
import de.adorsys.psd2.xs2a.web.validator.body.payment.type.SinglePaymentTypeValidatorImpl;
import java.util.List;
import java.util.Objects;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class BulkPaymentTypeValidatorImpl
extends SinglePaymentTypeValidatorImpl {
    @Autowired
    public BulkPaymentTypeValidatorImpl(ErrorBuildingService errorBuildingService, ObjectMapper objectMapper, PaymentMapper paymentMapper) {
        super(errorBuildingService, objectMapper, paymentMapper);
    }

    @Override
    public PaymentType getPaymentType() {
        return PaymentType.BULK;
    }

    @Override
    public void validate(Object body, MessageError messageError) {
        try {
            this.doBulkValidation(this.paymentMapper.getBulkPayment(body), messageError);
        }
        catch (IllegalArgumentException e) {
            this.errorBuildingService.enrichMessageError(messageError, e.getMessage());
        }
    }

    void doBulkValidation(BulkPayment bulkPayment, MessageError messageError) {
        if (Objects.nonNull(bulkPayment.getDebtorAccount())) {
            this.validateAccount(bulkPayment.getDebtorAccount(), messageError);
        }
        List<SinglePayment> payments = bulkPayment.getPayments();
        payments.forEach(singlePayment -> super.doSingleValidation((SinglePayment)singlePayment, messageError));
        if (this.isDateInThePast(bulkPayment.getRequestedExecutionDate())) {
            this.errorBuildingService.enrichMessageError(messageError, TppMessageInformation.of(MessageErrorCode.EXECUTION_DATE_INVALID, "Value 'requestedExecutionDate' should not be in the past"));
        }
    }
}

