/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.web.validator.body.payment;

import com.fasterxml.jackson.databind.ObjectMapper;
import de.adorsys.psd2.xs2a.component.JsonConverter;
import de.adorsys.psd2.xs2a.core.pis.PurposeCode;
import de.adorsys.psd2.xs2a.domain.MessageErrorCode;
import de.adorsys.psd2.xs2a.domain.TppMessageInformation;
import de.adorsys.psd2.xs2a.exception.MessageError;
import de.adorsys.psd2.xs2a.service.profile.StandardPaymentProductsResolver;
import de.adorsys.psd2.xs2a.web.validator.ErrorBuildingService;
import de.adorsys.psd2.xs2a.web.validator.body.AbstractBodyValidatorImpl;
import de.adorsys.psd2.xs2a.web.validator.body.DateFieldValidator;
import de.adorsys.psd2.xs2a.web.validator.body.payment.PaymentBodyValidator;
import de.adorsys.psd2.xs2a.web.validator.body.payment.type.PaymentTypeValidator;
import de.adorsys.psd2.xs2a.web.validator.body.payment.type.PaymentTypeValidatorContext;
import de.adorsys.psd2.xs2a.web.validator.constants.Xs2aRequestBodyDateFields;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.web.servlet.HandlerMapping;

@Component
public class PaymentBodyValidatorImpl
extends AbstractBodyValidatorImpl
implements PaymentBodyValidator {
    private static final String PAYMENT_SERVICE_PATH_VAR = "payment-service";
    private static final String PAYMENT_PRODUCT_PATH_VAR = "payment-product";
    private static final String PURPOSE_CODE_FIELD_NAME = "purposeCode";
    private static final String BODY_DESERIALIZATION_ERROR = "Cannot deserialize the request body";
    static final String PURPOSE_CODE_ERROR_FORMAT = "Field 'purposeCode' has wrong value";
    private PaymentTypeValidatorContext paymentTypeValidatorContext;
    private DateFieldValidator dateFieldValidator;
    private JsonConverter jsonConverter;
    private final StandardPaymentProductsResolver standardPaymentProductsResolver;

    @Autowired
    public PaymentBodyValidatorImpl(ErrorBuildingService errorBuildingService, ObjectMapper objectMapper, PaymentTypeValidatorContext paymentTypeValidatorContext, StandardPaymentProductsResolver standardPaymentProductsResolver, DateFieldValidator dateFieldValidator, JsonConverter jsonConverter) {
        super(errorBuildingService, objectMapper);
        this.paymentTypeValidatorContext = paymentTypeValidatorContext;
        this.standardPaymentProductsResolver = standardPaymentProductsResolver;
        this.dateFieldValidator = dateFieldValidator;
        this.jsonConverter = jsonConverter;
    }

    @Override
    public void validateBodyFields(HttpServletRequest request, MessageError messageError) {
        Map pathParametersMap = (Map)request.getAttribute(HandlerMapping.URI_TEMPLATE_VARIABLES_ATTRIBUTE);
        if (this.isRawPaymentProduct(pathParametersMap)) {
            return;
        }
        Optional<Object> bodyOptional = this.mapBodyToInstance(request, messageError, Object.class);
        if (!bodyOptional.isPresent()) {
            return;
        }
        this.validateInitiatePaymentBody(bodyOptional.get(), pathParametersMap, messageError);
    }

    @Override
    public void validateRawData(HttpServletRequest request, MessageError messageError) {
        this.dateFieldValidator.validateDayOfExecution(request, messageError);
        this.dateFieldValidator.validateDateFormat(request, Xs2aRequestBodyDateFields.PAYMENT_DATE_FIELDS.getDateFields(), messageError);
        List<String> purposeCodes = this.extractPurposeCodes(request, messageError);
        this.validatePurposeCodes(purposeCodes, messageError);
    }

    private void validateInitiatePaymentBody(Object body, Map<String, String> pathParametersMap, MessageError messageError) {
        String paymentService = pathParametersMap.get(PAYMENT_SERVICE_PATH_VAR);
        Optional<PaymentTypeValidator> validator = this.paymentTypeValidatorContext.getValidator(paymentService);
        if (!validator.isPresent()) {
            throw new IllegalArgumentException("Unsupported payment service");
        }
        validator.get().validate(body, messageError);
    }

    private boolean isRawPaymentProduct(Map<String, String> pathParametersMap) {
        String paymentProduct = pathParametersMap.get(PAYMENT_PRODUCT_PATH_VAR);
        return this.standardPaymentProductsResolver.isRawPaymentProduct(paymentProduct);
    }

    private void validatePurposeCodes(List<String> purposeCodes, MessageError messageError) {
        boolean isPurposeCodesNotValid = purposeCodes.stream().map(PurposeCode::fromValue).anyMatch(Objects::isNull);
        if (isPurposeCodesNotValid) {
            this.enrichFormatMessageError(PURPOSE_CODE_ERROR_FORMAT, messageError);
        }
    }

    private void enrichFormatMessageError(String message, MessageError messageError) {
        this.errorBuildingService.enrichMessageError(messageError, TppMessageInformation.of(MessageErrorCode.FORMAT_ERROR, message));
    }

    private List<String> extractPurposeCodes(HttpServletRequest request, MessageError messageError) {
        ArrayList<String> purposeCodes = new ArrayList<String>();
        try {
            purposeCodes.addAll(this.jsonConverter.toJsonGetValuesForField((InputStream)request.getInputStream(), PURPOSE_CODE_FIELD_NAME));
        }
        catch (IOException e) {
            this.errorBuildingService.enrichMessageError(messageError, BODY_DESERIALIZATION_ERROR);
        }
        return purposeCodes;
    }
}

