/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.web.validator.body;

import de.adorsys.psd2.xs2a.exception.MessageError;
import de.adorsys.psd2.xs2a.web.validator.ErrorBuildingService;
import de.adorsys.psd2.xs2a.web.validator.ObjectValidator;
import de.adorsys.psd2.xs2a.web.validator.body.StringMaxLengthValidator;
import java.beans.ConstructorProperties;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.springframework.stereotype.Component;

@Component
public class RequiredFieldMaxLengthValidator
implements ObjectValidator<StringMaxLengthValidator.MaxLengthRequirement> {
    private final StringMaxLengthValidator stringMaxLengthValidator;
    private final ErrorBuildingService errorBuildingService;

    @Override
    public void validate(@NotNull StringMaxLengthValidator.MaxLengthRequirement object, @NotNull MessageError messageError) {
        if (StringUtils.isBlank((CharSequence)object.getField())) {
            String text = String.format("Value '%s' cannot be empty", object.getFieldName());
            this.errorBuildingService.enrichMessageError(messageError, text);
        } else {
            this.stringMaxLengthValidator.validate(object, messageError);
        }
    }

    @ConstructorProperties(value={"stringMaxLengthValidator", "errorBuildingService"})
    public RequiredFieldMaxLengthValidator(StringMaxLengthValidator stringMaxLengthValidator, ErrorBuildingService errorBuildingService) {
        this.stringMaxLengthValidator = stringMaxLengthValidator;
        this.errorBuildingService = errorBuildingService;
    }
}

