/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.web.validator.body;

import de.adorsys.psd2.model.AccountReference;
import de.adorsys.psd2.xs2a.exception.MessageError;
import de.adorsys.psd2.xs2a.web.validator.ErrorBuildingService;
import de.adorsys.psd2.xs2a.web.validator.ObjectValidator;
import de.adorsys.psd2.xs2a.web.validator.body.OptionalFieldMaxLengthValidator;
import de.adorsys.psd2.xs2a.web.validator.body.StringMaxLengthValidator;
import java.beans.ConstructorProperties;
import java.util.Currency;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.validator.routines.IBANValidator;
import org.jetbrains.annotations.NotNull;
import org.springframework.stereotype.Component;

@Component
public class AccountReferenceValidator
implements ObjectValidator<AccountReference> {
    private final ErrorBuildingService errorBuildingService;
    private final OptionalFieldMaxLengthValidator optionalFieldMaxLengthValidator;

    @Override
    public void validate(@NotNull AccountReference accountReference, @NotNull MessageError messageError) {
        if (StringUtils.isNotBlank((CharSequence)accountReference.getIban()) && !this.isValidIban(accountReference.getIban())) {
            this.errorBuildingService.enrichMessageError(messageError, "Invalid IBAN format");
        }
        if (StringUtils.isNotBlank((CharSequence)accountReference.getBban()) && !this.isValidBban(accountReference.getBban())) {
            this.errorBuildingService.enrichMessageError(messageError, "Invalid BBAN format");
        }
        this.optionalFieldMaxLengthValidator.validate(new StringMaxLengthValidator.MaxLengthRequirement(accountReference.getPan(), "PAN", 35), messageError);
        this.optionalFieldMaxLengthValidator.validate(new StringMaxLengthValidator.MaxLengthRequirement(accountReference.getMaskedPan(), "Masked PAN", 35), messageError);
        this.optionalFieldMaxLengthValidator.validate(new StringMaxLengthValidator.MaxLengthRequirement(accountReference.getMsisdn(), "MSISDN", 35), messageError);
        if (Objects.nonNull(accountReference.getCurrency())) {
            this.validateCurrency(accountReference.getCurrency(), messageError);
        }
    }

    private boolean isValidIban(String iban) {
        IBANValidator validator = IBANValidator.getInstance();
        return validator.isValid(iban);
    }

    private boolean isValidBban(String bban) {
        return this.normalizeString(bban).length() >= 11 && this.normalizeString(bban).length() <= 28;
    }

    private boolean isValidCurrency(String currency) {
        try {
            Currency.getInstance(currency);
        }
        catch (IllegalArgumentException e) {
            return false;
        }
        return true;
    }

    private void validateCurrency(String currency, MessageError messageError) {
        if (!this.isValidCurrency(currency)) {
            this.errorBuildingService.enrichMessageError(messageError, "Invalid currency code format");
        }
    }

    private String normalizeString(String string) {
        return string.replaceAll("[^a-zA-Z0-9]", "");
    }

    @ConstructorProperties(value={"errorBuildingService", "optionalFieldMaxLengthValidator"})
    public AccountReferenceValidator(ErrorBuildingService errorBuildingService, OptionalFieldMaxLengthValidator optionalFieldMaxLengthValidator) {
        this.errorBuildingService = errorBuildingService;
        this.optionalFieldMaxLengthValidator = optionalFieldMaxLengthValidator;
    }
}

