/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.web.link;

import de.adorsys.psd2.xs2a.core.profile.ScaApproach;
import de.adorsys.psd2.xs2a.domain.HrefType;
import de.adorsys.psd2.xs2a.domain.consent.CreateConsentResponse;
import de.adorsys.psd2.xs2a.service.RedirectIdService;
import de.adorsys.psd2.xs2a.service.ScaApproachResolver;
import de.adorsys.psd2.xs2a.web.RedirectLinkBuilder;
import de.adorsys.psd2.xs2a.web.link.AbstractLinks;
import java.util.EnumSet;

public class CreateConsentLinks
extends AbstractLinks {
    public CreateConsentLinks(String httpUrl, ScaApproachResolver scaApproachResolver, CreateConsentResponse response, RedirectLinkBuilder redirectLinkBuilder, RedirectIdService redirectIdService, boolean explicitMethod, boolean signingBasketModeActive) {
        super(httpUrl);
        ScaApproach scaApproach;
        String consentId = response.getConsentId();
        String authorisationId = response.getAuthorizationId();
        this.setSelf(this.buildPath("/v1/consents/{consentId}", consentId));
        this.setStatus(this.buildPath("/v1/consents/{consentId}/status", consentId));
        ScaApproach scaApproach2 = scaApproach = authorisationId == null ? scaApproachResolver.resolveScaApproach() : scaApproachResolver.getInitiationScaApproach(authorisationId);
        if (EnumSet.of(ScaApproach.EMBEDDED, ScaApproach.DECOUPLED).contains(scaApproach)) {
            this.buildLinkForEmbeddedAndDecoupledScaApproach(consentId, authorisationId, explicitMethod, signingBasketModeActive);
        } else if (ScaApproach.REDIRECT == scaApproach) {
            if (explicitMethod) {
                this.setStartAuthorisation(this.buildPath("/v1/consents/{consentId}/authorisations", consentId));
            } else {
                String redirectId = redirectIdService.generateRedirectId(authorisationId);
                this.setScaRedirect(new HrefType(redirectLinkBuilder.buildConsentScaRedirectLink(consentId, redirectId)));
                this.setScaStatus(this.buildPath("/v1/consents/{consentId}/authorisations/{authorisation-id}", consentId, authorisationId));
            }
        }
    }

    private void buildLinkForEmbeddedAndDecoupledScaApproach(String consentId, String authorizationId, boolean explicitMethod, boolean signingBasketModeActive) {
        if (explicitMethod) {
            if (signingBasketModeActive) {
                this.setStartAuthorisation(this.buildPath("/v1/consents/{consentId}/authorisations", consentId));
            } else {
                this.setStartAuthorisationWithPsuAuthentication(this.buildPath("/v1/consents/{consentId}/authorisations", consentId));
            }
        } else {
            this.setScaStatus(this.buildPath("/v1/consents/{consentId}/authorisations/{authorisation-id}", consentId, authorizationId));
            this.setUpdatePsuAuthentication(this.buildPath("/v1/consents/{consentId}/authorisations/{authorisation-id}", consentId, authorizationId));
        }
    }
}

