/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.web.interceptor.tpp;

import com.fasterxml.jackson.databind.ObjectMapper;
import de.adorsys.psd2.consent.api.service.TppStopListService;
import de.adorsys.psd2.xs2a.core.tpp.TppInfo;
import de.adorsys.psd2.xs2a.core.tpp.TppUniqueParamsHolder;
import de.adorsys.psd2.xs2a.domain.MessageErrorCode;
import de.adorsys.psd2.xs2a.domain.TppMessageInformation;
import de.adorsys.psd2.xs2a.exception.MessageError;
import de.adorsys.psd2.xs2a.service.RequestProviderService;
import de.adorsys.psd2.xs2a.service.TppService;
import de.adorsys.psd2.xs2a.service.discovery.ServiceTypeDiscoveryService;
import de.adorsys.psd2.xs2a.service.mapper.psd2.ErrorMapperContainer;
import de.adorsys.psd2.xs2a.service.mapper.psd2.ServiceTypeToErrorTypeMapper;
import java.beans.ConstructorProperties;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;

public class TppStopListInterceptor
extends HandlerInterceptorAdapter {
    private static final Logger log = LoggerFactory.getLogger(TppStopListInterceptor.class);
    private static final String STOP_LIST_ERROR_MESSAGE = "Signature/corporate seal certificate has been blocked by the ASPSP";
    private final ErrorMapperContainer errorMapperContainer;
    private final TppService tppService;
    private final TppStopListService tppStopListService;
    private final ServiceTypeDiscoveryService serviceTypeDiscoveryService;
    private final ServiceTypeToErrorTypeMapper errorTypeMapper;
    private final ObjectMapper objectMapper;
    private final RequestProviderService requestProviderService;

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        TppInfo tppInfo = this.tppService.getTppInfo();
        if (this.tppStopListService.checkIfTppBlocked(new TppUniqueParamsHolder(tppInfo.getAuthorisationNumber(), tppInfo.getAuthorityId()))) {
            response.getWriter().write(this.objectMapper.writeValueAsString(this.createError()));
            response.setContentType("application/json");
            response.setStatus(MessageErrorCode.CERTIFICATE_BLOCKED.getCode());
            log.info("InR-ID: [{}], X-Request-ID: [{}]. TPP {}.", new Object[]{this.requestProviderService.getInternalRequestId(), this.requestProviderService.getRequestId(), STOP_LIST_ERROR_MESSAGE});
            return false;
        }
        return true;
    }

    private Object createError() {
        MessageError messageError = new MessageError(this.errorTypeMapper.mapToErrorType(this.serviceTypeDiscoveryService.getServiceType(), MessageErrorCode.CERTIFICATE_BLOCKED.getCode()), this.buildErrorTppMessages());
        return Optional.ofNullable(this.errorMapperContainer.getErrorBody(messageError)).map(ErrorMapperContainer.ErrorBody::getBody).orElse(null);
    }

    private TppMessageInformation buildErrorTppMessages() {
        return TppMessageInformation.of(MessageErrorCode.CERTIFICATE_BLOCKED, STOP_LIST_ERROR_MESSAGE);
    }

    @ConstructorProperties(value={"errorMapperContainer", "tppService", "tppStopListService", "serviceTypeDiscoveryService", "errorTypeMapper", "objectMapper", "requestProviderService"})
    public TppStopListInterceptor(ErrorMapperContainer errorMapperContainer, TppService tppService, TppStopListService tppStopListService, ServiceTypeDiscoveryService serviceTypeDiscoveryService, ServiceTypeToErrorTypeMapper errorTypeMapper, ObjectMapper objectMapper, RequestProviderService requestProviderService) {
        this.errorMapperContainer = errorMapperContainer;
        this.tppService = tppService;
        this.tppStopListService = tppStopListService;
        this.serviceTypeDiscoveryService = serviceTypeDiscoveryService;
        this.errorTypeMapper = errorTypeMapper;
        this.objectMapper = objectMapper;
        this.requestProviderService = requestProviderService;
    }
}

