/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service.validator.ais.account.common;

import de.adorsys.psd2.xs2a.core.consent.ConsentStatus;
import de.adorsys.psd2.xs2a.domain.MessageErrorCode;
import de.adorsys.psd2.xs2a.domain.TppMessageInformation;
import de.adorsys.psd2.xs2a.domain.consent.AccountConsent;
import de.adorsys.psd2.xs2a.service.RequestProviderService;
import de.adorsys.psd2.xs2a.service.mapper.psd2.ErrorType;
import de.adorsys.psd2.xs2a.service.validator.ValidationResult;
import java.beans.ConstructorProperties;
import java.time.LocalDate;
import org.springframework.stereotype.Component;

@Component
public class AccountConsentValidator {
    private final RequestProviderService requestProviderService;

    public ValidationResult validate(AccountConsent accountConsent, String requestUri) {
        if (LocalDate.now().compareTo(accountConsent.getValidUntil()) > 0) {
            return ValidationResult.invalid(ErrorType.AIS_401, TppMessageInformation.of(MessageErrorCode.CONSENT_EXPIRED));
        }
        ConsentStatus consentStatus = accountConsent.getConsentStatus();
        if (consentStatus != ConsentStatus.VALID) {
            MessageErrorCode messageErrorCode = consentStatus == ConsentStatus.RECEIVED ? MessageErrorCode.CONSENT_INVALID : MessageErrorCode.CONSENT_EXPIRED;
            return ValidationResult.invalid(ErrorType.AIS_401, TppMessageInformation.of(messageErrorCode));
        }
        if (this.isAccessExceeded(accountConsent, requestUri)) {
            return ValidationResult.invalid(ErrorType.AIS_429, TppMessageInformation.of(MessageErrorCode.ACCESS_EXCEEDED));
        }
        return ValidationResult.valid();
    }

    private boolean isAccessExceeded(AccountConsent accountConsent, String requestUri) {
        if (this.requestProviderService.isRequestFromPsu()) {
            return false;
        }
        if (!accountConsent.getUsageCounterMap().containsKey(requestUri)) {
            return false;
        }
        return accountConsent.getUsageCounterMap().get(requestUri) <= 0;
    }

    @ConstructorProperties(value={"requestProviderService"})
    public AccountConsentValidator(RequestProviderService requestProviderService) {
        this.requestProviderService = requestProviderService;
    }
}

