/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service.validator.ais.account.common;

import de.adorsys.psd2.xs2a.core.profile.AccountReference;
import de.adorsys.psd2.xs2a.domain.MessageErrorCode;
import de.adorsys.psd2.xs2a.domain.TppMessageInformation;
import de.adorsys.psd2.xs2a.domain.consent.AccountConsent;
import de.adorsys.psd2.xs2a.domain.consent.Xs2aAccountAccess;
import de.adorsys.psd2.xs2a.service.mapper.psd2.ErrorType;
import de.adorsys.psd2.xs2a.service.validator.ValidationResult;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.stereotype.Component;

@Component
public class AccountAccessMultipleAccountsValidator {
    public ValidationResult validate(AccountConsent accountConsent, boolean withBalance) {
        if (withBalance && accountConsent.isConsentForDedicatedAccounts()) {
            Xs2aAccountAccess access = accountConsent.getAccess();
            return this.validateAccountReferenceSize(access.getAccounts(), access.getBalances()) ? ValidationResult.invalid(ErrorType.AIS_401, TppMessageInformation.of(MessageErrorCode.CONSENT_INVALID)) : ValidationResult.valid();
        }
        return ValidationResult.valid();
    }

    private boolean validateAccountReferenceSize(List<AccountReference> accounts, List<AccountReference> balances) {
        return CollectionUtils.isNotEmpty(accounts) && CollectionUtils.isNotEmpty(balances) && accounts.size() > balances.size();
    }
}

