/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service.validator.ais.account;

import de.adorsys.psd2.xs2a.service.validator.ValidationResult;
import de.adorsys.psd2.xs2a.service.validator.ais.AbstractAisTppValidator;
import de.adorsys.psd2.xs2a.service.validator.ais.account.common.AccountAccessMultipleAccountsValidator;
import de.adorsys.psd2.xs2a.service.validator.ais.account.common.AccountAccessValidator;
import de.adorsys.psd2.xs2a.service.validator.ais.account.common.AccountConsentValidator;
import de.adorsys.psd2.xs2a.service.validator.ais.account.dto.GetAccountListConsentObject;
import java.beans.ConstructorProperties;
import org.jetbrains.annotations.NotNull;
import org.springframework.stereotype.Component;

@Component
public class GetAccountListValidator
extends AbstractAisTppValidator<GetAccountListConsentObject> {
    private final AccountConsentValidator accountConsentValidator;
    private final AccountAccessValidator accountAccessValidator;
    private final AccountAccessMultipleAccountsValidator accountAccessMultipleAccountsValidator;

    @Override
    @NotNull
    protected ValidationResult executeBusinessValidation(GetAccountListConsentObject consentObject) {
        ValidationResult accountConsentValidationResult = this.accountConsentValidator.validate(consentObject.getAccountConsent(), consentObject.getRequestUri());
        if (accountConsentValidationResult.isNotValid()) {
            return accountConsentValidationResult;
        }
        ValidationResult accountAccessValidationResult = this.accountAccessValidator.validate(consentObject.getAccountConsent(), consentObject.isWithBalance());
        if (accountAccessValidationResult.isNotValid()) {
            return accountAccessValidationResult;
        }
        ValidationResult accountAccessMultipleAccountsValidatorResult = this.accountAccessMultipleAccountsValidator.validate(consentObject.getAccountConsent(), consentObject.isWithBalance());
        if (accountAccessMultipleAccountsValidatorResult.isNotValid()) {
            return accountAccessMultipleAccountsValidatorResult;
        }
        return ValidationResult.valid();
    }

    @ConstructorProperties(value={"accountConsentValidator", "accountAccessValidator", "accountAccessMultipleAccountsValidator"})
    public GetAccountListValidator(AccountConsentValidator accountConsentValidator, AccountAccessValidator accountAccessValidator, AccountAccessMultipleAccountsValidator accountAccessMultipleAccountsValidator) {
        this.accountConsentValidator = accountConsentValidator;
        this.accountAccessValidator = accountAccessValidator;
        this.accountAccessMultipleAccountsValidator = accountAccessMultipleAccountsValidator;
    }
}

