/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service.validator.ais;

import de.adorsys.psd2.xs2a.core.tpp.TppInfo;
import de.adorsys.psd2.xs2a.service.validator.BusinessValidator;
import de.adorsys.psd2.xs2a.service.validator.TppInfoProvider;
import de.adorsys.psd2.xs2a.service.validator.ValidationResult;
import de.adorsys.psd2.xs2a.service.validator.tpp.AisTppInfoValidator;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public abstract class AbstractAisTppValidator<T extends TppInfoProvider>
implements BusinessValidator<T> {
    private AisTppInfoValidator aisTppInfoValidator;

    @Override
    @NotNull
    public ValidationResult validate(@NotNull T object) {
        TppInfo tppInfoInConsent = object.getTppInfo();
        ValidationResult tppValidationResult = this.aisTppInfoValidator.validateTpp(tppInfoInConsent);
        if (tppValidationResult.isNotValid()) {
            return tppValidationResult;
        }
        return this.executeBusinessValidation(object);
    }

    @NotNull
    protected abstract ValidationResult executeBusinessValidation(T var1);

    @Autowired
    public void setPisTppInfoValidator(AisTppInfoValidator aisTppInfoValidator) {
        this.aisTppInfoValidator = aisTppInfoValidator;
    }
}

