/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service.validator;

import de.adorsys.psd2.consent.api.pis.proto.PisCommonPaymentResponse;
import de.adorsys.psd2.xs2a.core.profile.PaymentType;
import de.adorsys.psd2.xs2a.domain.MessageErrorCode;
import de.adorsys.psd2.xs2a.domain.TppMessageInformation;
import de.adorsys.psd2.xs2a.service.RequestProviderService;
import de.adorsys.psd2.xs2a.service.mapper.psd2.ErrorType;
import de.adorsys.psd2.xs2a.service.validator.ValidationResult;
import java.beans.ConstructorProperties;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class GetCommonPaymentByIdResponseValidator {
    private static final Logger log = LoggerFactory.getLogger(GetCommonPaymentByIdResponseValidator.class);
    private final RequestProviderService requestProviderService;

    public ValidationResult validateRequest(@Nullable PisCommonPaymentResponse pisCommonPayment, PaymentType paymentType, String paymentProduct) {
        if (pisCommonPayment == null) {
            log.info("InR-ID: [{}], X-Request-ID: [{}]. Payment validation has failed: payment was not found", (Object)this.requestProviderService.getInternalRequestId(), (Object)this.requestProviderService.getRequestId());
            return ValidationResult.invalid(ErrorType.PIS_404, TppMessageInformation.of(MessageErrorCode.RESOURCE_UNKNOWN_404, "Payment not found"));
        }
        if (this.isPaymentTypeIncorrect(paymentType, pisCommonPayment)) {
            log.info("InR-ID: [{}], X-Request-ID: [{}], Payment ID: [{}]. Payment validation has failed: payment type [{}] is incorrect", new Object[]{this.requestProviderService.getInternalRequestId(), this.requestProviderService.getRequestId(), pisCommonPayment.getExternalId(), paymentType});
            return ValidationResult.invalid(ErrorType.PIS_405, TppMessageInformation.of(MessageErrorCode.SERVICE_INVALID_405, "Service invalid for addressed payment"));
        }
        if (this.isPaymentProductIncorrect(paymentProduct, pisCommonPayment)) {
            log.info("InR-ID: [{}], X-Request-ID: [{}], Payment ID: [{}]. Payment validation has failed: payment product [{}] is incorrect", new Object[]{this.requestProviderService.getInternalRequestId(), this.requestProviderService.getRequestId(), pisCommonPayment.getExternalId(), paymentProduct});
            return ValidationResult.invalid(ErrorType.PIS_403, TppMessageInformation.of(MessageErrorCode.PRODUCT_INVALID, "Payment product invalid for addressed payment"));
        }
        return ValidationResult.valid();
    }

    private boolean isPaymentTypeIncorrect(PaymentType paymentType, PisCommonPaymentResponse commonPaymentResponse) {
        return commonPaymentResponse.getPaymentType() != paymentType;
    }

    private boolean isPaymentProductIncorrect(String paymentProduct, PisCommonPaymentResponse commonPaymentResponse) {
        return !commonPaymentResponse.getPaymentProduct().equalsIgnoreCase(paymentProduct);
    }

    @ConstructorProperties(value={"requestProviderService"})
    public GetCommonPaymentByIdResponseValidator(RequestProviderService requestProviderService) {
        this.requestProviderService = requestProviderService;
    }
}

