/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service.payment;

import de.adorsys.psd2.consent.api.pis.PisPayment;
import de.adorsys.psd2.xs2a.core.consent.AspspConsentData;
import de.adorsys.psd2.xs2a.core.pis.TransactionStatus;
import de.adorsys.psd2.xs2a.core.psu.PsuIdData;
import de.adorsys.psd2.xs2a.domain.ErrorHolder;
import de.adorsys.psd2.xs2a.domain.MessageErrorCode;
import de.adorsys.psd2.xs2a.domain.pis.PaymentInformationResponse;
import de.adorsys.psd2.xs2a.domain.pis.SinglePayment;
import de.adorsys.psd2.xs2a.service.RequestProviderService;
import de.adorsys.psd2.xs2a.service.consent.PisAspspDataService;
import de.adorsys.psd2.xs2a.service.context.SpiContextDataProvider;
import de.adorsys.psd2.xs2a.service.mapper.psd2.ServiceType;
import de.adorsys.psd2.xs2a.service.mapper.spi_xs2a_mappers.SpiErrorMapper;
import de.adorsys.psd2.xs2a.service.mapper.spi_xs2a_mappers.SpiToXs2aSinglePaymentMapper;
import de.adorsys.psd2.xs2a.service.payment.ReadPaymentService;
import de.adorsys.psd2.xs2a.service.payment.SpiPaymentFactory;
import de.adorsys.psd2.xs2a.service.payment.Xs2aUpdatePaymentAfterSpiService;
import de.adorsys.psd2.xs2a.spi.domain.SpiContextData;
import de.adorsys.psd2.xs2a.spi.domain.payment.SpiSinglePayment;
import de.adorsys.psd2.xs2a.spi.domain.response.SpiResponse;
import de.adorsys.psd2.xs2a.spi.service.SinglePaymentSpi;
import java.beans.ConstructorProperties;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="payments")
public class ReadSinglePaymentService
extends ReadPaymentService<PaymentInformationResponse<SinglePayment>> {
    private static final Logger log = LoggerFactory.getLogger(ReadSinglePaymentService.class);
    private final PisAspspDataService pisAspspDataService;
    private final SpiContextDataProvider spiContextDataProvider;
    private final Xs2aUpdatePaymentAfterSpiService updatePaymentStatusAfterSpiService;
    private final SinglePaymentSpi singlePaymentSpi;
    private final SpiToXs2aSinglePaymentMapper spiToXs2aSinglePaymentMapper;
    private final SpiErrorMapper spiErrorMapper;
    private final SpiPaymentFactory spiPaymentFactory;
    private final RequestProviderService requestProviderService;

    @Override
    public PaymentInformationResponse<SinglePayment> getPayment(List<PisPayment> pisPayments, String paymentProduct, PsuIdData psuData, AspspConsentData aspspConsentData) {
        Optional<SpiSinglePayment> spiPaymentOptional = this.spiPaymentFactory.createSpiSinglePayment(pisPayments.get(0), paymentProduct);
        if (!spiPaymentOptional.isPresent()) {
            return new PaymentInformationResponse<SinglePayment>(ErrorHolder.builder(MessageErrorCode.RESOURCE_UNKNOWN_404).messages(Collections.singletonList("Payment not found")).build());
        }
        SpiContextData spiContextData = this.spiContextDataProvider.provideWithPsuIdData(psuData);
        SpiResponse spiResponse = this.singlePaymentSpi.getPaymentById(spiContextData, spiPaymentOptional.get(), aspspConsentData);
        this.pisAspspDataService.updateAspspConsentData(spiResponse.getAspspConsentData());
        if (spiResponse.hasError()) {
            ErrorHolder errorHolder = this.spiErrorMapper.mapToErrorHolder(spiResponse, ServiceType.PIS);
            log.info("InR-ID: [{}], X-Request-ID: [{}], Payment-ID [{}]. READ SINGLE Payment failed. Can't get Payment by id at SPI-level. Error msg: [{}]", new Object[]{this.requestProviderService.getInternalRequestId(), this.requestProviderService.getRequestId(), spiPaymentOptional.get().getPaymentId(), errorHolder});
            return new PaymentInformationResponse<SinglePayment>(errorHolder);
        }
        SpiSinglePayment spiSinglePayment = (SpiSinglePayment)spiResponse.getPayload();
        SinglePayment xs2aSinglePayment = this.spiToXs2aSinglePaymentMapper.mapToXs2aSinglePayment(spiSinglePayment);
        TransactionStatus paymentStatus = xs2aSinglePayment.getTransactionStatus();
        if (!this.updatePaymentStatusAfterSpiService.updatePaymentStatus(aspspConsentData.getConsentId(), paymentStatus)) {
            log.info("InR-ID: [{}], X-Request-ID: [{}], Internal payment ID: [{}], Transaction status: [{}]. Update of a payment status in the CMS has failed.", new Object[]{this.requestProviderService.getInternalRequestId(), this.requestProviderService.getRequestId(), xs2aSinglePayment.getPaymentId(), paymentStatus});
        }
        return new PaymentInformationResponse<SinglePayment>(xs2aSinglePayment);
    }

    @ConstructorProperties(value={"pisAspspDataService", "spiContextDataProvider", "updatePaymentStatusAfterSpiService", "singlePaymentSpi", "spiToXs2aSinglePaymentMapper", "spiErrorMapper", "spiPaymentFactory", "requestProviderService"})
    public ReadSinglePaymentService(PisAspspDataService pisAspspDataService, SpiContextDataProvider spiContextDataProvider, Xs2aUpdatePaymentAfterSpiService updatePaymentStatusAfterSpiService, SinglePaymentSpi singlePaymentSpi, SpiToXs2aSinglePaymentMapper spiToXs2aSinglePaymentMapper, SpiErrorMapper spiErrorMapper, SpiPaymentFactory spiPaymentFactory, RequestProviderService requestProviderService) {
        this.pisAspspDataService = pisAspspDataService;
        this.spiContextDataProvider = spiContextDataProvider;
        this.updatePaymentStatusAfterSpiService = updatePaymentStatusAfterSpiService;
        this.singlePaymentSpi = singlePaymentSpi;
        this.spiToXs2aSinglePaymentMapper = spiToXs2aSinglePaymentMapper;
        this.spiErrorMapper = spiErrorMapper;
        this.spiPaymentFactory = spiPaymentFactory;
        this.requestProviderService = requestProviderService;
    }
}

