/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service.payment;

import de.adorsys.psd2.consent.api.pis.PisPayment;
import de.adorsys.psd2.xs2a.core.consent.AspspConsentData;
import de.adorsys.psd2.xs2a.core.pis.TransactionStatus;
import de.adorsys.psd2.xs2a.core.psu.PsuIdData;
import de.adorsys.psd2.xs2a.domain.ErrorHolder;
import de.adorsys.psd2.xs2a.domain.MessageErrorCode;
import de.adorsys.psd2.xs2a.domain.pis.PaymentInformationResponse;
import de.adorsys.psd2.xs2a.domain.pis.PeriodicPayment;
import de.adorsys.psd2.xs2a.service.RequestProviderService;
import de.adorsys.psd2.xs2a.service.consent.PisAspspDataService;
import de.adorsys.psd2.xs2a.service.context.SpiContextDataProvider;
import de.adorsys.psd2.xs2a.service.mapper.psd2.ServiceType;
import de.adorsys.psd2.xs2a.service.mapper.spi_xs2a_mappers.SpiErrorMapper;
import de.adorsys.psd2.xs2a.service.mapper.spi_xs2a_mappers.SpiToXs2aPeriodicPaymentMapper;
import de.adorsys.psd2.xs2a.service.payment.ReadPaymentService;
import de.adorsys.psd2.xs2a.service.payment.SpiPaymentFactory;
import de.adorsys.psd2.xs2a.service.payment.Xs2aUpdatePaymentAfterSpiService;
import de.adorsys.psd2.xs2a.spi.domain.SpiContextData;
import de.adorsys.psd2.xs2a.spi.domain.payment.SpiPeriodicPayment;
import de.adorsys.psd2.xs2a.spi.domain.response.SpiResponse;
import de.adorsys.psd2.xs2a.spi.service.PeriodicPaymentSpi;
import java.beans.ConstructorProperties;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="periodic-payments")
public class ReadPeriodicPaymentService
extends ReadPaymentService<PaymentInformationResponse<PeriodicPayment>> {
    private static final Logger log = LoggerFactory.getLogger(ReadPeriodicPaymentService.class);
    private final PisAspspDataService pisAspspDataService;
    private final SpiContextDataProvider spiContextDataProvider;
    private final Xs2aUpdatePaymentAfterSpiService updatePaymentStatusAfterSpiService;
    private final PeriodicPaymentSpi periodicPaymentSpi;
    private final SpiToXs2aPeriodicPaymentMapper spiToXs2aPeriodicPaymentMapper;
    private final SpiErrorMapper spiErrorMapper;
    private final SpiPaymentFactory spiPaymentFactory;
    private final RequestProviderService requestProviderService;

    @Override
    public PaymentInformationResponse<PeriodicPayment> getPayment(List<PisPayment> pisPayments, String paymentProduct, PsuIdData psuData, AspspConsentData aspspConsentData) {
        Optional<SpiPeriodicPayment> spiPaymentOptional = this.spiPaymentFactory.createSpiPeriodicPayment(pisPayments.get(0), paymentProduct);
        if (!spiPaymentOptional.isPresent()) {
            return new PaymentInformationResponse<PeriodicPayment>(ErrorHolder.builder(MessageErrorCode.RESOURCE_UNKNOWN_404).messages(Collections.singletonList("Payment not found")).build());
        }
        SpiContextData spiContextData = this.spiContextDataProvider.provideWithPsuIdData(psuData);
        SpiResponse spiResponse = this.periodicPaymentSpi.getPaymentById(spiContextData, spiPaymentOptional.get(), aspspConsentData);
        this.pisAspspDataService.updateAspspConsentData(spiResponse.getAspspConsentData());
        if (spiResponse.hasError()) {
            ErrorHolder errorHolder = this.spiErrorMapper.mapToErrorHolder(spiResponse, ServiceType.PIS);
            log.info("InR-ID: [{}], X-Request-ID: [{}], Payment-ID [{}]. READ PERIODIC Payment failed. Can't get Payment by id at SPI-level. Error msg: [{}]", new Object[]{this.requestProviderService.getInternalRequestId(), this.requestProviderService.getRequestId(), spiPaymentOptional.get().getPaymentId(), errorHolder});
            return new PaymentInformationResponse<PeriodicPayment>(errorHolder);
        }
        SpiPeriodicPayment spiResponsePayment = (SpiPeriodicPayment)spiResponse.getPayload();
        PeriodicPayment xs2aPeriodicPayment = this.spiToXs2aPeriodicPaymentMapper.mapToXs2aPeriodicPayment(spiResponsePayment);
        TransactionStatus paymentStatus = xs2aPeriodicPayment.getTransactionStatus();
        if (!this.updatePaymentStatusAfterSpiService.updatePaymentStatus(aspspConsentData.getConsentId(), paymentStatus)) {
            log.info("InR-ID: [{}], X-Request-ID: [{}], Internal payment ID: [{}], Transaction status: [{}]. Update of a payment status in the CMS has failed.", new Object[]{this.requestProviderService.getInternalRequestId(), this.requestProviderService.getRequestId(), xs2aPeriodicPayment.getPaymentId(), paymentStatus});
        }
        return new PaymentInformationResponse<PeriodicPayment>(xs2aPeriodicPayment);
    }

    @ConstructorProperties(value={"pisAspspDataService", "spiContextDataProvider", "updatePaymentStatusAfterSpiService", "periodicPaymentSpi", "spiToXs2aPeriodicPaymentMapper", "spiErrorMapper", "spiPaymentFactory", "requestProviderService"})
    public ReadPeriodicPaymentService(PisAspspDataService pisAspspDataService, SpiContextDataProvider spiContextDataProvider, Xs2aUpdatePaymentAfterSpiService updatePaymentStatusAfterSpiService, PeriodicPaymentSpi periodicPaymentSpi, SpiToXs2aPeriodicPaymentMapper spiToXs2aPeriodicPaymentMapper, SpiErrorMapper spiErrorMapper, SpiPaymentFactory spiPaymentFactory, RequestProviderService requestProviderService) {
        this.pisAspspDataService = pisAspspDataService;
        this.spiContextDataProvider = spiContextDataProvider;
        this.updatePaymentStatusAfterSpiService = updatePaymentStatusAfterSpiService;
        this.periodicPaymentSpi = periodicPaymentSpi;
        this.spiToXs2aPeriodicPaymentMapper = spiToXs2aPeriodicPaymentMapper;
        this.spiErrorMapper = spiErrorMapper;
        this.spiPaymentFactory = spiPaymentFactory;
        this.requestProviderService = requestProviderService;
    }
}

