/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service.mapper.psd2;

import de.adorsys.psd2.xs2a.exception.MessageError;
import de.adorsys.psd2.xs2a.service.RequestProviderService;
import de.adorsys.psd2.xs2a.service.mapper.psd2.ErrorMapperContainer;
import de.adorsys.psd2.xs2a.web.header.ResponseHeaders;
import java.beans.ConstructorProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.MultiValueMap;

@Component
public class ResponseErrorMapper {
    private static final Logger log = LoggerFactory.getLogger(ResponseErrorMapper.class);
    private final ErrorMapperContainer errorMapperContainer;
    private final RequestProviderService requestProviderService;

    public ResponseEntity generateErrorResponse(MessageError error) {
        ErrorMapperContainer.ErrorBody errorBody = this.errorMapperContainer.getErrorBody(error);
        log.info("InR-ID: [{}], X-Request-ID: [{}]. Generate error: [{}]", new Object[]{this.requestProviderService.getInternalRequestId(), this.requestProviderService.getRequestId(), error});
        return new ResponseEntity(errorBody.getBody(), errorBody.getStatus());
    }

    public ResponseEntity generateErrorResponse(MessageError error, ResponseHeaders responseHeaders) {
        ErrorMapperContainer.ErrorBody errorBody = this.errorMapperContainer.getErrorBody(error);
        log.info("InR-ID: [{}], X-Request-ID: [{}]. Generate error: [{}]", new Object[]{this.requestProviderService.getInternalRequestId(), this.requestProviderService.getRequestId(), error});
        return new ResponseEntity(errorBody.getBody(), (MultiValueMap)responseHeaders.getHttpHeaders(), errorBody.getStatus());
    }

    @ConstructorProperties(value={"errorMapperContainer", "requestProviderService"})
    public ResponseErrorMapper(ErrorMapperContainer errorMapperContainer, RequestProviderService requestProviderService) {
        this.errorMapperContainer = errorMapperContainer;
        this.requestProviderService = requestProviderService;
    }
}

