/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service.authorization.pis;

import de.adorsys.psd2.xs2a.core.consent.AspspConsentData;
import de.adorsys.psd2.xs2a.core.psu.PsuIdData;
import de.adorsys.psd2.xs2a.core.sca.ScaStatus;
import de.adorsys.psd2.xs2a.domain.ErrorHolder;
import de.adorsys.psd2.xs2a.domain.consent.Xs2aAuthenticationObject;
import de.adorsys.psd2.xs2a.domain.consent.pis.Xs2aDecoupledUpdatePisCommonPaymentPsuDataResponse;
import de.adorsys.psd2.xs2a.domain.consent.pis.Xs2aUpdatePisCommonPaymentPsuDataRequest;
import de.adorsys.psd2.xs2a.domain.consent.pis.Xs2aUpdatePisCommonPaymentPsuDataResponse;
import de.adorsys.psd2.xs2a.domain.pis.PaymentAuthorisationType;
import de.adorsys.psd2.xs2a.service.RequestProviderService;
import de.adorsys.psd2.xs2a.service.consent.PisAspspDataService;
import de.adorsys.psd2.xs2a.service.context.SpiContextDataProvider;
import de.adorsys.psd2.xs2a.service.mapper.psd2.ServiceType;
import de.adorsys.psd2.xs2a.service.mapper.spi_xs2a_mappers.SpiErrorMapper;
import de.adorsys.psd2.xs2a.spi.domain.authorisation.SpiAuthorisationDecoupledScaResponse;
import de.adorsys.psd2.xs2a.spi.domain.response.SpiResponse;
import de.adorsys.psd2.xs2a.spi.service.PaymentAuthorisationSpi;
import de.adorsys.psd2.xs2a.spi.service.PaymentCancellationSpi;
import de.adorsys.psd2.xs2a.spi.service.SpiPayment;
import java.beans.ConstructorProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class PisCommonDecoupledService {
    private static final Logger log = LoggerFactory.getLogger(PisCommonDecoupledService.class);
    private final PaymentAuthorisationSpi paymentAuthorisationSpi;
    private final PaymentCancellationSpi paymentCancellationSpi;
    private final SpiContextDataProvider spiContextDataProvider;
    private final PisAspspDataService pisAspspDataService;
    private final SpiErrorMapper spiErrorMapper;
    private final RequestProviderService requestProviderService;

    public Xs2aUpdatePisCommonPaymentPsuDataResponse proceedDecoupledInitiation(Xs2aUpdatePisCommonPaymentPsuDataRequest request, SpiPayment payment) {
        return this.proceedDecoupledInitiation(request, payment, null);
    }

    public Xs2aUpdatePisCommonPaymentPsuDataResponse proceedDecoupledInitiation(Xs2aUpdatePisCommonPaymentPsuDataRequest request, SpiPayment payment, String authenticationMethodId) {
        return this.proceedDecoupled(request, payment, authenticationMethodId, PaymentAuthorisationType.INITIATION);
    }

    public Xs2aUpdatePisCommonPaymentPsuDataResponse proceedDecoupledCancellation(Xs2aUpdatePisCommonPaymentPsuDataRequest request, SpiPayment payment) {
        return this.proceedDecoupledCancellation(request, payment, null);
    }

    public Xs2aUpdatePisCommonPaymentPsuDataResponse proceedDecoupledCancellation(Xs2aUpdatePisCommonPaymentPsuDataRequest request, SpiPayment payment, String authenticationMethodId) {
        return this.proceedDecoupled(request, payment, authenticationMethodId, PaymentAuthorisationType.CANCELLATION);
    }

    private Xs2aUpdatePisCommonPaymentPsuDataResponse proceedDecoupled(Xs2aUpdatePisCommonPaymentPsuDataRequest request, SpiPayment payment, String authenticationMethodId, PaymentAuthorisationType scaType) {
        String authenticationId = request.getAuthorisationId();
        String paymentId = request.getPaymentId();
        PsuIdData psuData = request.getPsuData();
        AspspConsentData aspspConsentData = this.pisAspspDataService.getAspspConsentData(request.getPaymentId());
        SpiResponse spiResponse = null;
        switch (scaType) {
            case INITIATION: {
                spiResponse = this.paymentAuthorisationSpi.startScaDecoupled(this.spiContextDataProvider.provideWithPsuIdData(psuData), authenticationId, authenticationMethodId, (Object)payment, aspspConsentData);
                break;
            }
            case CANCELLATION: {
                spiResponse = this.paymentCancellationSpi.startScaDecoupled(this.spiContextDataProvider.provideWithPsuIdData(psuData), authenticationId, authenticationMethodId, (Object)payment, aspspConsentData);
                break;
            }
            default: {
                log.info("InR-ID: [{}], X-Request-ID: [{}], Payment-ID [{}]. Payment Authorisation Type {} is not supported.", new Object[]{this.requestProviderService.getInternalRequestId(), this.requestProviderService.getRequestId(), paymentId, scaType});
                throw new IllegalArgumentException("This SCA type is not supported: " + (Object)((Object)scaType));
            }
        }
        this.pisAspspDataService.updateAspspConsentData(spiResponse.getAspspConsentData());
        if (spiResponse.hasError()) {
            ErrorHolder errorHolder = this.spiErrorMapper.mapToErrorHolder(spiResponse, ServiceType.PIS);
            log.warn("InR-ID: [{}], X-Request-ID: [{}], Payment-ID [{}], Authorisation-ID [{}], PSU-ID [{}]. Start SPI Authorisation Decoupled SCA has failed. Error msg: {}.", new Object[]{this.requestProviderService.getInternalRequestId(), this.requestProviderService.getRequestId(), paymentId, authenticationId, psuData.getPsuId(), errorHolder});
            return new Xs2aUpdatePisCommonPaymentPsuDataResponse(errorHolder, paymentId, authenticationId, psuData);
        }
        Xs2aDecoupledUpdatePisCommonPaymentPsuDataResponse response = new Xs2aDecoupledUpdatePisCommonPaymentPsuDataResponse(ScaStatus.SCAMETHODSELECTED, request.getPaymentId(), request.getAuthorisationId(), psuData);
        response.setPsuMessage(((SpiAuthorisationDecoupledScaResponse)spiResponse.getPayload()).getPsuMessage());
        response.setChosenScaMethod(this.buildXs2aAuthenticationObjectForDecoupledApproach(request.getAuthenticationMethodId()));
        return response;
    }

    private Xs2aAuthenticationObject buildXs2aAuthenticationObjectForDecoupledApproach(String authenticationMethodId) {
        Xs2aAuthenticationObject xs2aAuthenticationObject = new Xs2aAuthenticationObject();
        xs2aAuthenticationObject.setAuthenticationMethodId(authenticationMethodId);
        return xs2aAuthenticationObject;
    }

    @ConstructorProperties(value={"paymentAuthorisationSpi", "paymentCancellationSpi", "spiContextDataProvider", "pisAspspDataService", "spiErrorMapper", "requestProviderService"})
    public PisCommonDecoupledService(PaymentAuthorisationSpi paymentAuthorisationSpi, PaymentCancellationSpi paymentCancellationSpi, SpiContextDataProvider spiContextDataProvider, PisAspspDataService pisAspspDataService, SpiErrorMapper spiErrorMapper, RequestProviderService requestProviderService) {
        this.paymentAuthorisationSpi = paymentAuthorisationSpi;
        this.paymentCancellationSpi = paymentCancellationSpi;
        this.spiContextDataProvider = spiContextDataProvider;
        this.pisAspspDataService = pisAspspDataService;
        this.spiErrorMapper = spiErrorMapper;
        this.requestProviderService = requestProviderService;
    }
}

