/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service.authorization;

import de.adorsys.psd2.xs2a.service.RequestProviderService;
import de.adorsys.psd2.xs2a.service.profile.AspspProfileServiceWrapper;
import java.beans.ConstructorProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class AuthorisationMethodDecider {
    private static final Logger log = LoggerFactory.getLogger(AuthorisationMethodDecider.class);
    private final AspspProfileServiceWrapper aspspProfileService;
    private final RequestProviderService requestProviderService;

    public boolean isExplicitMethod(boolean tppExplicitAuthorisationPreferred, boolean multilevelScaRequired) {
        boolean isExplicit = multilevelScaRequired || tppExplicitAuthorisationPreferred && this.aspspProfileService.isSigningBasketSupported();
        log.info("InR-ID: [{}], X-Request-ID: [{}]. {} authorisation method chosen", new Object[]{this.requestProviderService.getInternalRequestId(), this.requestProviderService.getRequestId(), isExplicit ? "EXPLICIT" : "IMPLICIT"});
        return isExplicit;
    }

    public boolean isImplicitMethod(boolean tppExplicitAuthorisationPreferred, boolean multilevelScaRequired) {
        return !this.isExplicitMethod(tppExplicitAuthorisationPreferred, multilevelScaRequired);
    }

    public boolean isSigningBasketModeActive(boolean tppExplicitAuthorisationPreferred) {
        return tppExplicitAuthorisationPreferred && this.aspspProfileService.isSigningBasketSupported();
    }

    @ConstructorProperties(value={"aspspProfileService", "requestProviderService"})
    public AuthorisationMethodDecider(AspspProfileServiceWrapper aspspProfileService, RequestProviderService requestProviderService) {
        this.aspspProfileService = aspspProfileService;
        this.requestProviderService = requestProviderService;
    }
}

