/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.component;

import de.adorsys.psd2.xs2a.core.profile.PaymentType;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.core.convert.converter.ConditionalGenericConverter;
import org.springframework.core.convert.converter.GenericConverter;

public class PaymentTypeEnumConverter
implements ConditionalGenericConverter {
    private static final Logger log = LoggerFactory.getLogger(PaymentTypeEnumConverter.class);

    public boolean matches(TypeDescriptor sourceType, TypeDescriptor targetType) {
        return targetType.getType().equals(PaymentType.class);
    }

    public Set<GenericConverter.ConvertiblePair> getConvertibleTypes() {
        return Collections.singleton(new GenericConverter.ConvertiblePair(String.class, PaymentType.class));
    }

    public Object convert(Object source, TypeDescriptor sourceType, TypeDescriptor targetType) {
        Optional paymentType = PaymentType.getByValue((String)((String)source));
        return paymentType.orElseThrow(() -> {
            log.info("Can't convert {} to existing payment type", source);
            return new IllegalArgumentException("Can't convert to existing payment type");
        });
    }
}

