package de.adorsys.psd2.xs2a.web.mapper;

import de.adorsys.psd2.model.Address;
import de.adorsys.psd2.xs2a.domain.address.Xs2aAddress;
import de.adorsys.psd2.xs2a.domain.address.Xs2aCountryCode;
import javax.annotation.Generated;
import org.springframework.stereotype.Component;

@Generated(
    value = "org.mapstruct.ap.MappingProcessor",
    date = "2019-08-30T06:26:09+0000",
    comments = "version: 1.3.0.Final, compiler: javac, environment: Java 1.8.0_222 (Private Build)"
)
@Component
public class Xs2aAddressMapperImpl implements Xs2aAddressMapper {

    @Override
    public Xs2aAddress mapToXs2aAddress(Address address) {
        if ( address == null ) {
            return null;
        }

        Xs2aAddress xs2aAddress = new Xs2aAddress();

        xs2aAddress.setCountry( mapToXs2aCountryCode( address ) );
        xs2aAddress.setStreet( address.getStreet() );
        xs2aAddress.setBuildingNumber( address.getBuildingNumber() );
        xs2aAddress.setCity( address.getCity() );
        xs2aAddress.setPostalCode( address.getPostalCode() );

        return xs2aAddress;
    }

    @Override
    public Address mapToAddress(Xs2aAddress address) {
        if ( address == null ) {
            return null;
        }

        Address address1 = new Address();

        address1.setCountry( addressCountryCode( address ) );
        address1.setStreet( address.getStreet() );
        address1.setBuildingNumber( address.getBuildingNumber() );
        address1.setCity( address.getCity() );
        address1.setPostalCode( address.getPostalCode() );

        return address1;
    }

    private String addressCountryCode(Xs2aAddress xs2aAddress) {
        if ( xs2aAddress == null ) {
            return null;
        }
        Xs2aCountryCode country = xs2aAddress.getCountry();
        if ( country == null ) {
            return null;
        }
        String code = country.getCode();
        if ( code == null ) {
            return null;
        }
        return code;
    }
}
