/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.web.validator.body.piis;

import com.fasterxml.jackson.databind.ObjectMapper;
import de.adorsys.psd2.model.ConfirmationOfFunds;
import de.adorsys.psd2.xs2a.exception.MessageError;
import de.adorsys.psd2.xs2a.web.validator.ErrorBuildingService;
import de.adorsys.psd2.xs2a.web.validator.body.AbstractBodyValidatorImpl;
import de.adorsys.psd2.xs2a.web.validator.body.AccountReferenceValidator;
import de.adorsys.psd2.xs2a.web.validator.body.piis.FundsConfirmationBodyValidator;
import java.util.Objects;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import org.springframework.stereotype.Component;

@Component
public class FundsConfirmationBodyValidatorImpl
extends AbstractBodyValidatorImpl
implements FundsConfirmationBodyValidator {
    private final AccountReferenceValidator accountReferenceValidator;

    public FundsConfirmationBodyValidatorImpl(ErrorBuildingService errorBuildingService, ObjectMapper objectMapper, AccountReferenceValidator accountReferenceValidator) {
        super(errorBuildingService, objectMapper);
        this.accountReferenceValidator = accountReferenceValidator;
    }

    @Override
    public void validate(HttpServletRequest request, MessageError messageError) {
        Optional<ConfirmationOfFunds> confirmationOfFundsOptional = this.mapBodyToInstance(request, messageError, ConfirmationOfFunds.class);
        if (!confirmationOfFundsOptional.isPresent()) {
            return;
        }
        ConfirmationOfFunds confirmationOfFunds = confirmationOfFundsOptional.get();
        if (Objects.isNull(confirmationOfFunds.getAccount())) {
            this.errorBuildingService.enrichMessageError(messageError, "Value 'access' should not be null");
        } else {
            this.accountReferenceValidator.validate(confirmationOfFunds.getAccount(), messageError);
        }
    }
}

