/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.web.validator;

import de.adorsys.psd2.xs2a.exception.MessageError;
import de.adorsys.psd2.xs2a.web.validator.MethodValidator;
import de.adorsys.psd2.xs2a.web.validator.RawBodyValidator;
import de.adorsys.psd2.xs2a.web.validator.body.BodyValidator;
import de.adorsys.psd2.xs2a.web.validator.header.HeaderValidator;
import de.adorsys.psd2.xs2a.web.validator.query.QueryParameterValidator;
import java.beans.ConstructorProperties;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.springframework.util.CollectionUtils;

public abstract class AbstractMethodValidator<H extends HeaderValidator, R extends RawBodyValidator, B extends BodyValidator, P extends QueryParameterValidator>
implements MethodValidator {
    private final List<H> headerValidators;
    private final List<R> rawBodyValidators;
    private final List<B> bodyValidators;
    private final List<P> queryParameterValidators;

    @Override
    public void validate(HttpServletRequest request, MessageError messageError) {
        Map<String, String> headers = Collections.list(request.getHeaderNames()).stream().collect(Collectors.toMap(h -> h, arg_0 -> ((HttpServletRequest)request).getHeader(arg_0)));
        TreeMap<String, String> caseInsensitiveHeaders = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
        caseInsensitiveHeaders.putAll(headers);
        this.getHeaderValidators().forEach(v -> v.validate(caseInsensitiveHeaders, messageError));
        this.getRawBodyValidators().forEach(v -> v.validate(request, messageError));
        if (!CollectionUtils.isEmpty(messageError.getTppMessages())) {
            return;
        }
        Map<String, List<String>> queryParameters = this.extractQueryParameters(request);
        this.getBodyValidators().forEach(v -> v.validate(request, messageError));
        this.getQueryParameterValidators().forEach(v -> v.validate(queryParameters, messageError));
    }

    private Map<String, List<String>> extractQueryParameters(HttpServletRequest request) {
        Map requestParameterMap = request.getParameterMap();
        return requestParameterMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> Arrays.asList((Object[])e.getValue())));
    }

    @ConstructorProperties(value={"headerValidators", "rawBodyValidators", "bodyValidators", "queryParameterValidators"})
    protected AbstractMethodValidator(List<H> headerValidators, List<R> rawBodyValidators, List<B> bodyValidators, List<P> queryParameterValidators) {
        this.headerValidators = headerValidators;
        this.rawBodyValidators = rawBodyValidators;
        this.bodyValidators = bodyValidators;
        this.queryParameterValidators = queryParameterValidators;
    }

    List<H> getHeaderValidators() {
        return this.headerValidators;
    }

    List<R> getRawBodyValidators() {
        return this.rawBodyValidators;
    }

    List<B> getBodyValidators() {
        return this.bodyValidators;
    }

    List<P> getQueryParameterValidators() {
        return this.queryParameterValidators;
    }
}

