/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service.validator.pis.authorisation.cancellation;

import de.adorsys.psd2.consent.api.pis.proto.PisCommonPaymentResponse;
import de.adorsys.psd2.xs2a.core.psu.PsuIdData;
import de.adorsys.psd2.xs2a.domain.MessageErrorCode;
import de.adorsys.psd2.xs2a.domain.TppMessageInformation;
import de.adorsys.psd2.xs2a.service.RequestProviderService;
import de.adorsys.psd2.xs2a.service.mapper.psd2.ErrorType;
import de.adorsys.psd2.xs2a.service.validator.ValidationResult;
import de.adorsys.psd2.xs2a.service.validator.pis.AbstractPisTppValidator;
import de.adorsys.psd2.xs2a.service.validator.pis.authorisation.cancellation.CreatePisCancellationAuthorisationPO;
import java.beans.ConstructorProperties;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class CreatePisCancellationAuthorisationValidator
extends AbstractPisTppValidator<CreatePisCancellationAuthorisationPO> {
    private static final Logger log = LoggerFactory.getLogger(CreatePisCancellationAuthorisationValidator.class);
    private final RequestProviderService requestProviderService;

    @Override
    protected ValidationResult executeBusinessValidation(CreatePisCancellationAuthorisationPO paymentObject) {
        PsuIdData psuData = paymentObject.getPsuData();
        PisCommonPaymentResponse pisCommonPaymentResponse = paymentObject.getPisCommonPaymentResponse();
        if (psuData.isNotEmpty() && !this.isPsuDataCorrect(pisCommonPaymentResponse, psuData)) {
            log.info("InR-ID: [{}], X-Request-ID: [{}], Payment ID: [{}]. Creation of PIS cancellation authorisation has failed: PSU Data in request doesn't match PSU Data in payment", new Object[]{this.requestProviderService.getInternalRequestId(), this.requestProviderService.getRequestId(), pisCommonPaymentResponse.getExternalId()});
            return ValidationResult.invalid(ErrorType.PIS_401, TppMessageInformation.of(MessageErrorCode.PSU_CREDENTIALS_INVALID));
        }
        return ValidationResult.valid();
    }

    private boolean isPsuDataCorrect(PisCommonPaymentResponse pisCommonPaymentResponse, PsuIdData psuData) {
        List psuIdDataList = pisCommonPaymentResponse.getPsuData();
        return psuIdDataList.stream().anyMatch(psu -> psu.contentEquals(psuData));
    }

    @ConstructorProperties(value={"requestProviderService"})
    public CreatePisCancellationAuthorisationValidator(RequestProviderService requestProviderService) {
        this.requestProviderService = requestProviderService;
    }
}

