/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service.validator.piis;

import de.adorsys.psd2.xs2a.core.consent.ConsentStatus;
import de.adorsys.psd2.xs2a.core.piis.PiisConsent;
import de.adorsys.psd2.xs2a.core.piis.PiisConsentTppAccessType;
import de.adorsys.psd2.xs2a.domain.ErrorHolder;
import de.adorsys.psd2.xs2a.domain.MessageErrorCode;
import de.adorsys.psd2.xs2a.domain.TppMessageInformation;
import de.adorsys.psd2.xs2a.domain.fund.PiisConsentValidationResult;
import de.adorsys.psd2.xs2a.exception.MessageError;
import de.adorsys.psd2.xs2a.service.RequestProviderService;
import de.adorsys.psd2.xs2a.service.mapper.psd2.ErrorType;
import de.adorsys.psd2.xs2a.service.validator.ValidationResult;
import de.adorsys.psd2.xs2a.service.validator.tpp.PiisTppInfoValidator;
import java.beans.ConstructorProperties;
import java.time.LocalDate;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class PiisConsentValidation {
    private static final Logger log = LoggerFactory.getLogger(PiisConsentValidation.class);
    private final RequestProviderService requestProviderService;
    private final PiisTppInfoValidator piisTppInfoValidator;

    public PiisConsentValidationResult validatePiisConsentData(List<PiisConsent> piisConsents) {
        if (CollectionUtils.isEmpty(piisConsents)) {
            return new PiisConsentValidationResult(ErrorHolder.builder(MessageErrorCode.NO_PIIS_ACTIVATION).errorType(ErrorType.PIIS_400).build());
        }
        Optional<PiisConsent> filteredPiisConsent = piisConsents.stream().filter(e -> EnumSet.of(ConsentStatus.VALID, ConsentStatus.RECEIVED).contains(e.getConsentStatus())).filter(e -> Optional.ofNullable(e.getExpireDate()).map(d -> d.compareTo(LocalDate.now()) >= 0).orElse(true)).filter(e -> e.getAllowedFrequencyPerDay() > 0).sorted(Comparator.comparing(PiisConsent::getCreationTimestamp, Comparator.nullsLast(Comparator.reverseOrder()))).findAny();
        ValidationResult validationResult = filteredPiisConsent.map(this::isTppValid).orElseGet(() -> ValidationResult.invalid(ErrorType.PIIS_400, TppMessageInformation.of(MessageErrorCode.CONSENT_UNKNOWN_400)));
        if (validationResult.isNotValid()) {
            return new PiisConsentValidationResult(this.buildErrorHolderFromMessageError(validationResult.getMessageError()));
        }
        return new PiisConsentValidationResult(filteredPiisConsent.get());
    }

    private ValidationResult isTppValid(PiisConsent piisConsent) {
        if (piisConsent.getTppAccessType() == PiisConsentTppAccessType.ALL_TPP) {
            return ValidationResult.valid();
        }
        if (piisConsent.getTppAccessType() == PiisConsentTppAccessType.SINGLE_TPP) {
            return this.piisTppInfoValidator.validateTpp(piisConsent.getTppInfo());
        }
        PiisConsentTppAccessType accessType = piisConsent.getTppAccessType();
        log.error("InR-ID: [{}], X-Request-ID: [{}]. Unknown TPP access type: {}", new Object[]{this.requestProviderService.getInternalRequestId(), this.requestProviderService.getRequestId(), accessType});
        return ValidationResult.invalid(ErrorType.PIIS_400, TppMessageInformation.of(MessageErrorCode.CONSENT_UNKNOWN_400, String.format("Unknown TPP access type: {}", accessType)));
    }

    private ErrorHolder buildErrorHolderFromMessageError(MessageError messageError) {
        Optional<TppMessageInformation> messageErrorOptional = Optional.ofNullable(messageError).map(MessageError::getTppMessage);
        Optional<ErrorHolder.ErrorHolderBuilder> builderOptional = messageErrorOptional.map(TppMessageInformation::getMessageErrorCode).map(ErrorHolder::builder);
        if (builderOptional.isPresent()) {
            ErrorHolder.ErrorHolderBuilder builder = builderOptional.get();
            List messages = messageErrorOptional.map(TppMessageInformation::getText).map(Collections::singletonList).orElse(null);
            builder.errorType(messageError.getErrorType());
            builder.messages(messages);
            return builder.build();
        }
        return ErrorHolder.builder(MessageErrorCode.CONSENT_UNKNOWN_400).build();
    }

    @ConstructorProperties(value={"requestProviderService", "piisTppInfoValidator"})
    public PiisConsentValidation(RequestProviderService requestProviderService, PiisTppInfoValidator piisTppInfoValidator) {
        this.requestProviderService = requestProviderService;
        this.piisTppInfoValidator = piisTppInfoValidator;
    }
}

