/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service.validator.ais.account.common;

import de.adorsys.psd2.aspsp.profile.service.AspspProfileService;
import de.adorsys.psd2.xs2a.core.ais.AccountResponseType;
import de.adorsys.psd2.xs2a.domain.MessageErrorCode;
import de.adorsys.psd2.xs2a.domain.TppMessageInformation;
import de.adorsys.psd2.xs2a.service.mapper.psd2.ErrorType;
import de.adorsys.psd2.xs2a.service.validator.ValidationResult;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.Objects;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

@Component
public class TransactionReportAcceptHeaderValidator {
    private static final String WILDCARD_ACCEPT_HEADER = "*/*";
    private final AspspProfileService aspspProfileService;

    public ValidationResult validate(String acceptHeader) {
        List supportedTransactionApplicationTypes;
        if (StringUtils.isNotBlank((CharSequence)acceptHeader) && !WILDCARD_ACCEPT_HEADER.equals(acceptHeader) && !this.isAtLeastOneAcceptHeaderSupported(supportedTransactionApplicationTypes = this.aspspProfileService.getAspspSettings().getSupportedTransactionApplicationTypes(), acceptHeader)) {
            return ValidationResult.invalid(ErrorType.AIS_406, TppMessageInformation.of(MessageErrorCode.REQUESTED_FORMATS_INVALID));
        }
        return ValidationResult.valid();
    }

    private boolean isAtLeastOneAcceptHeaderSupported(List<String> supportedHeaders, String acceptHeader) {
        return CollectionUtils.isEmpty(supportedHeaders) || supportedHeaders.stream().map(AccountResponseType::fromValue).filter(Objects::nonNull).anyMatch(tp -> acceptHeader.toLowerCase().contains(tp.getValue()));
    }

    @ConstructorProperties(value={"aspspProfileService"})
    public TransactionReportAcceptHeaderValidator(AspspProfileService aspspProfileService) {
        this.aspspProfileService = aspspProfileService;
    }
}

