/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service.validator.ais.account;

import de.adorsys.psd2.xs2a.domain.consent.Xs2aAccountAccess;
import de.adorsys.psd2.xs2a.service.validator.ValidationResult;
import de.adorsys.psd2.xs2a.service.validator.ais.AbstractAisTppValidator;
import de.adorsys.psd2.xs2a.service.validator.ais.account.common.AccountConsentValidator;
import de.adorsys.psd2.xs2a.service.validator.ais.account.common.AccountReferenceAccessValidator;
import de.adorsys.psd2.xs2a.service.validator.ais.account.dto.CommonAccountTransactionsRequestObject;
import java.beans.ConstructorProperties;
import org.jetbrains.annotations.NotNull;
import org.springframework.stereotype.Component;

@Component
public class GetTransactionDetailsValidator
extends AbstractAisTppValidator<CommonAccountTransactionsRequestObject> {
    private final AccountConsentValidator accountConsentValidator;
    private final AccountReferenceAccessValidator accountReferenceAccessValidator;

    @Override
    @NotNull
    protected ValidationResult executeBusinessValidation(CommonAccountTransactionsRequestObject consentObject) {
        Xs2aAccountAccess accountAccess = consentObject.getAccountConsent().getAccess();
        ValidationResult accountReferenceValidationResult = this.accountReferenceAccessValidator.validate(accountAccess, accountAccess.getTransactions(), consentObject.getAccountId());
        if (accountReferenceValidationResult.isNotValid()) {
            return accountReferenceValidationResult;
        }
        return this.accountConsentValidator.validate(consentObject.getAccountConsent(), consentObject.getRequestUri());
    }

    @ConstructorProperties(value={"accountConsentValidator", "accountReferenceAccessValidator"})
    public GetTransactionDetailsValidator(AccountConsentValidator accountConsentValidator, AccountReferenceAccessValidator accountReferenceAccessValidator) {
        this.accountConsentValidator = accountConsentValidator;
        this.accountReferenceAccessValidator = accountReferenceAccessValidator;
    }
}

