/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service.payment;

import de.adorsys.psd2.consent.api.pis.proto.PisCommonPaymentResponse;
import de.adorsys.psd2.xs2a.core.consent.AspspConsentData;
import de.adorsys.psd2.xs2a.core.pis.TransactionStatus;
import de.adorsys.psd2.xs2a.domain.ErrorHolder;
import de.adorsys.psd2.xs2a.domain.pis.CommonPayment;
import de.adorsys.psd2.xs2a.domain.pis.ReadPaymentStatusResponse;
import de.adorsys.psd2.xs2a.service.RequestProviderService;
import de.adorsys.psd2.xs2a.service.consent.PisAspspDataService;
import de.adorsys.psd2.xs2a.service.mapper.consent.CmsToXs2aPaymentMapper;
import de.adorsys.psd2.xs2a.service.mapper.psd2.ServiceType;
import de.adorsys.psd2.xs2a.service.mapper.spi_xs2a_mappers.SpiErrorMapper;
import de.adorsys.psd2.xs2a.service.mapper.spi_xs2a_mappers.Xs2aToSpiPaymentInfoMapper;
import de.adorsys.psd2.xs2a.spi.domain.SpiContextData;
import de.adorsys.psd2.xs2a.spi.domain.payment.SpiPaymentInfo;
import de.adorsys.psd2.xs2a.spi.domain.response.SpiResponse;
import de.adorsys.psd2.xs2a.spi.service.CommonPaymentSpi;
import java.beans.ConstructorProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class ReadCommonPaymentStatusService {
    private static final Logger log = LoggerFactory.getLogger(ReadCommonPaymentStatusService.class);
    private final PisAspspDataService pisAspspDataService;
    private final CommonPaymentSpi commonPaymentSpi;
    private final SpiErrorMapper spiErrorMapper;
    private final Xs2aToSpiPaymentInfoMapper xs2aToSpiPaymentInfoMapper;
    private final CmsToXs2aPaymentMapper cmsToXs2aPaymentMapper;
    private final RequestProviderService requestProviderService;

    public ReadPaymentStatusResponse readPaymentStatus(PisCommonPaymentResponse pisCommonPaymentResponse, SpiContextData spiContextData, AspspConsentData aspspConsentData) {
        CommonPayment commonPayment = this.cmsToXs2aPaymentMapper.mapToXs2aCommonPayment(pisCommonPaymentResponse);
        SpiPaymentInfo request = this.xs2aToSpiPaymentInfoMapper.mapToSpiPaymentInfo(commonPayment);
        SpiResponse spiResponse = this.commonPaymentSpi.getPaymentStatusById(spiContextData, request, aspspConsentData);
        this.pisAspspDataService.updateAspspConsentData(spiResponse.getAspspConsentData());
        if (spiResponse.hasError()) {
            ErrorHolder errorHolder = this.spiErrorMapper.mapToErrorHolder(spiResponse, ServiceType.PIS);
            log.info("InR-ID: [{}], X-Request-ID: [{}], Payment-ID [{}]. READ COMMON Payment STATUS failed. Can't get Payment status by id at SPI-level. Error msg: [{}]", new Object[]{this.requestProviderService.getInternalRequestId(), this.requestProviderService.getRequestId(), commonPayment.getPaymentId(), errorHolder});
            return new ReadPaymentStatusResponse(errorHolder);
        }
        return new ReadPaymentStatusResponse((TransactionStatus)spiResponse.getPayload());
    }

    @ConstructorProperties(value={"pisAspspDataService", "commonPaymentSpi", "spiErrorMapper", "xs2aToSpiPaymentInfoMapper", "cmsToXs2aPaymentMapper", "requestProviderService"})
    public ReadCommonPaymentStatusService(PisAspspDataService pisAspspDataService, CommonPaymentSpi commonPaymentSpi, SpiErrorMapper spiErrorMapper, Xs2aToSpiPaymentInfoMapper xs2aToSpiPaymentInfoMapper, CmsToXs2aPaymentMapper cmsToXs2aPaymentMapper, RequestProviderService requestProviderService) {
        this.pisAspspDataService = pisAspspDataService;
        this.commonPaymentSpi = commonPaymentSpi;
        this.spiErrorMapper = spiErrorMapper;
        this.xs2aToSpiPaymentInfoMapper = xs2aToSpiPaymentInfoMapper;
        this.cmsToXs2aPaymentMapper = cmsToXs2aPaymentMapper;
        this.requestProviderService = requestProviderService;
    }
}

