/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service.payment;

import de.adorsys.psd2.consent.api.pis.proto.PisPaymentInfo;
import de.adorsys.psd2.xs2a.core.consent.AspspConsentData;
import de.adorsys.psd2.xs2a.core.profile.PaymentType;
import de.adorsys.psd2.xs2a.core.psu.PsuIdData;
import de.adorsys.psd2.xs2a.core.tpp.TppInfo;
import de.adorsys.psd2.xs2a.domain.MessageErrorCode;
import de.adorsys.psd2.xs2a.domain.ResponseObject;
import de.adorsys.psd2.xs2a.domain.TppMessageInformation;
import de.adorsys.psd2.xs2a.domain.consent.Xs2aCreatePisAuthorisationResponse;
import de.adorsys.psd2.xs2a.domain.consent.Xs2aPisCommonPayment;
import de.adorsys.psd2.xs2a.domain.pis.PaymentInitiationParameters;
import de.adorsys.psd2.xs2a.domain.pis.PeriodicPayment;
import de.adorsys.psd2.xs2a.domain.pis.PeriodicPaymentInitiationResponse;
import de.adorsys.psd2.xs2a.service.authorization.AuthorisationMethodDecider;
import de.adorsys.psd2.xs2a.service.authorization.pis.PisScaAuthorisationService;
import de.adorsys.psd2.xs2a.service.authorization.pis.PisScaAuthorisationServiceResolver;
import de.adorsys.psd2.xs2a.service.consent.PisAspspDataService;
import de.adorsys.psd2.xs2a.service.consent.Xs2aPisCommonPaymentService;
import de.adorsys.psd2.xs2a.service.mapper.consent.Xs2aPisCommonPaymentMapper;
import de.adorsys.psd2.xs2a.service.mapper.consent.Xs2aToCmsPisCommonPaymentRequestMapper;
import de.adorsys.psd2.xs2a.service.mapper.psd2.ErrorType;
import de.adorsys.psd2.xs2a.service.payment.CreatePaymentService;
import de.adorsys.psd2.xs2a.service.payment.sca.ScaPaymentService;
import de.adorsys.psd2.xs2a.service.payment.sca.ScaPaymentServiceResolver;
import java.beans.ConstructorProperties;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

@Service
public class CreatePeriodicPaymentService
implements CreatePaymentService<PeriodicPayment, PeriodicPaymentInitiationResponse> {
    private final ScaPaymentServiceResolver scaPaymentServiceResolver;
    private final Xs2aPisCommonPaymentService pisCommonPaymentService;
    private final AuthorisationMethodDecider authorisationMethodDecider;
    private final Xs2aPisCommonPaymentMapper xs2aPisCommonPaymentMapper;
    private final Xs2aToCmsPisCommonPaymentRequestMapper xs2aToCmsPisCommonPaymentRequestMapper;
    private final PisAspspDataService pisAspspDataService;
    private final PisScaAuthorisationServiceResolver pisScaAuthorisationServiceResolver;

    @Override
    public ResponseObject<PeriodicPaymentInitiationResponse> createPayment(PeriodicPayment periodicPayment, PaymentInitiationParameters paymentInitiationParameters, TppInfo tppInfo) {
        PsuIdData psuData = paymentInitiationParameters.getPsuData();
        ScaPaymentService scaPaymentService = (ScaPaymentService)this.scaPaymentServiceResolver.getService();
        PeriodicPaymentInitiationResponse response = scaPaymentService.createPeriodicPayment(periodicPayment, tppInfo, paymentInitiationParameters.getPaymentProduct(), psuData);
        if (response.hasError()) {
            return this.buildErrorResponse(response.getErrorHolder());
        }
        PisPaymentInfo pisPaymentInfo = this.xs2aToCmsPisCommonPaymentRequestMapper.mapToPisPaymentInfo(paymentInitiationParameters, tppInfo, response);
        Xs2aPisCommonPayment pisCommonPayment = this.xs2aPisCommonPaymentMapper.mapToXs2aPisCommonPayment(this.pisCommonPaymentService.createCommonPayment(pisPaymentInfo), psuData);
        String externalPaymentId = pisCommonPayment.getPaymentId();
        if (StringUtils.isBlank((CharSequence)externalPaymentId)) {
            return ResponseObject.builder().fail(ErrorType.PIS_400, TppMessageInformation.of(MessageErrorCode.PAYMENT_FAILED)).build();
        }
        AspspConsentData aspspConsentData = response.getAspspConsentData();
        this.pisAspspDataService.updateAspspConsentData(new AspspConsentData(aspspConsentData.getAspspConsentData(), externalPaymentId));
        periodicPayment.setTransactionStatus(response.getTransactionStatus());
        periodicPayment.setPaymentId(response.getPaymentId());
        this.pisCommonPaymentService.updatePeriodicPaymentInCommonPayment(periodicPayment, paymentInitiationParameters, pisCommonPayment.getPaymentId());
        response.setPaymentId(externalPaymentId);
        boolean implicitMethod = this.authorisationMethodDecider.isImplicitMethod(paymentInitiationParameters.isTppExplicitAuthorisationPreferred(), response.isMultilevelScaRequired());
        if (implicitMethod) {
            PisScaAuthorisationService pisScaAuthorisationService = (PisScaAuthorisationService)this.pisScaAuthorisationServiceResolver.getService();
            Optional<Xs2aCreatePisAuthorisationResponse> consentAuthorisation = pisScaAuthorisationService.createCommonPaymentAuthorisation(externalPaymentId, PaymentType.PERIODIC, paymentInitiationParameters.getPsuData());
            if (!consentAuthorisation.isPresent()) {
                return ResponseObject.builder().fail(ErrorType.PIS_400, TppMessageInformation.of(MessageErrorCode.PAYMENT_FAILED)).build();
            }
            Xs2aCreatePisAuthorisationResponse authorisationResponse = consentAuthorisation.get();
            response.setAuthorizationId(authorisationResponse.getAuthorisationId());
            response.setScaStatus(authorisationResponse.getScaStatus());
        }
        return ResponseObject.builder().body(response).build();
    }

    @ConstructorProperties(value={"scaPaymentServiceResolver", "pisCommonPaymentService", "authorisationMethodDecider", "xs2aPisCommonPaymentMapper", "xs2aToCmsPisCommonPaymentRequestMapper", "pisAspspDataService", "pisScaAuthorisationServiceResolver"})
    public CreatePeriodicPaymentService(ScaPaymentServiceResolver scaPaymentServiceResolver, Xs2aPisCommonPaymentService pisCommonPaymentService, AuthorisationMethodDecider authorisationMethodDecider, Xs2aPisCommonPaymentMapper xs2aPisCommonPaymentMapper, Xs2aToCmsPisCommonPaymentRequestMapper xs2aToCmsPisCommonPaymentRequestMapper, PisAspspDataService pisAspspDataService, PisScaAuthorisationServiceResolver pisScaAuthorisationServiceResolver) {
        this.scaPaymentServiceResolver = scaPaymentServiceResolver;
        this.pisCommonPaymentService = pisCommonPaymentService;
        this.authorisationMethodDecider = authorisationMethodDecider;
        this.xs2aPisCommonPaymentMapper = xs2aPisCommonPaymentMapper;
        this.xs2aToCmsPisCommonPaymentRequestMapper = xs2aToCmsPisCommonPaymentRequestMapper;
        this.pisAspspDataService = pisAspspDataService;
        this.pisScaAuthorisationServiceResolver = pisScaAuthorisationServiceResolver;
    }
}

