/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service.message;

import java.beans.ConstructorProperties;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.MessageSource;
import org.springframework.context.NoSuchMessageException;
import org.springframework.stereotype.Service;

@Service
public class MessageService {
    private static final Logger log = LoggerFactory.getLogger(MessageService.class);
    private final MessageSource messageSource;

    public String getMessage(String code) {
        try {
            return this.messageSource.getMessage(code, null, Locale.forLanguageTag("en"));
        }
        catch (NoSuchMessageException e) {
            log.info("Can't get message: {}", (Object)e.getMessage());
            return null;
        }
    }

    @ConstructorProperties(value={"messageSource"})
    public MessageService(MessageSource messageSource) {
        this.messageSource = messageSource;
    }
}

