/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service.mapper.consent;

import de.adorsys.psd2.consent.api.ais.AisConsentAuthorizationRequest;
import de.adorsys.psd2.consent.api.ais.AisConsentAuthorizationResponse;
import de.adorsys.psd2.xs2a.core.profile.ScaApproach;
import de.adorsys.psd2.xs2a.core.psu.PsuIdData;
import de.adorsys.psd2.xs2a.core.sca.ScaStatus;
import de.adorsys.psd2.xs2a.domain.consent.AccountConsentAuthorization;
import de.adorsys.psd2.xs2a.domain.consent.UpdateConsentPsuDataReq;
import java.util.Optional;
import org.springframework.stereotype.Service;

@Service
public class Xs2aAisConsentAuthorisationMapper {
    public AccountConsentAuthorization mapToAccountConsentAuthorization(AisConsentAuthorizationResponse spiConsentAuthorization) {
        return Optional.ofNullable(spiConsentAuthorization).map(conAuth -> {
            AccountConsentAuthorization consentAuthorization = new AccountConsentAuthorization();
            consentAuthorization.setId(conAuth.getAuthorizationId());
            consentAuthorization.setConsentId(conAuth.getConsentId());
            consentAuthorization.setPsuIdData(conAuth.getPsuIdData());
            consentAuthorization.setScaStatus(conAuth.getScaStatus());
            consentAuthorization.setAuthenticationMethodId(conAuth.getAuthenticationMethodId());
            consentAuthorization.setScaAuthenticationData(conAuth.getScaAuthenticationData());
            consentAuthorization.setPassword(conAuth.getPassword());
            consentAuthorization.setChosenScaApproach(conAuth.getChosenScaApproach());
            return consentAuthorization;
        }).orElse(null);
    }

    public AisConsentAuthorizationRequest mapToAisConsentAuthorization(ScaStatus scaStatus, PsuIdData psuData, ScaApproach scaApproach) {
        return Optional.ofNullable(scaStatus).map(st -> {
            AisConsentAuthorizationRequest consentAuthorization = new AisConsentAuthorizationRequest();
            consentAuthorization.setPsuData(psuData);
            consentAuthorization.setScaStatus(scaStatus);
            consentAuthorization.setScaApproach(scaApproach);
            return consentAuthorization;
        }).orElse(null);
    }

    public AisConsentAuthorizationRequest mapToAisConsentAuthorizationRequest(UpdateConsentPsuDataReq updatePsuData) {
        return Optional.ofNullable(updatePsuData).map(data -> {
            AisConsentAuthorizationRequest consentAuthorization = new AisConsentAuthorizationRequest();
            consentAuthorization.setPsuData(data.getPsuData());
            consentAuthorization.setScaStatus(data.getScaStatus());
            consentAuthorization.setAuthenticationMethodId(data.getAuthenticationMethodId());
            consentAuthorization.setPassword(data.getPassword());
            consentAuthorization.setScaAuthenticationData(data.getScaAuthenticationData());
            return consentAuthorization;
        }).orElse(null);
    }
}

