/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service;

import de.adorsys.psd2.consent.api.service.PiisConsentService;
import de.adorsys.psd2.xs2a.core.consent.AspspConsentData;
import de.adorsys.psd2.xs2a.core.event.EventType;
import de.adorsys.psd2.xs2a.core.piis.PiisConsent;
import de.adorsys.psd2.xs2a.core.profile.AccountReference;
import de.adorsys.psd2.xs2a.core.profile.AccountReferenceSelector;
import de.adorsys.psd2.xs2a.core.psu.PsuIdData;
import de.adorsys.psd2.xs2a.domain.ErrorHolder;
import de.adorsys.psd2.xs2a.domain.MessageErrorCode;
import de.adorsys.psd2.xs2a.domain.ResponseObject;
import de.adorsys.psd2.xs2a.domain.fund.FundsConfirmationRequest;
import de.adorsys.psd2.xs2a.domain.fund.FundsConfirmationResponse;
import de.adorsys.psd2.xs2a.domain.fund.PiisConsentValidationResult;
import de.adorsys.psd2.xs2a.exception.MessageError;
import de.adorsys.psd2.xs2a.service.FundsConfirmationConsentDataService;
import de.adorsys.psd2.xs2a.service.RequestProviderService;
import de.adorsys.psd2.xs2a.service.context.SpiContextDataProvider;
import de.adorsys.psd2.xs2a.service.event.Xs2aEventService;
import de.adorsys.psd2.xs2a.service.mapper.psd2.ErrorType;
import de.adorsys.psd2.xs2a.service.mapper.psd2.ServiceType;
import de.adorsys.psd2.xs2a.service.mapper.spi_xs2a_mappers.SpiErrorMapper;
import de.adorsys.psd2.xs2a.service.mapper.spi_xs2a_mappers.SpiToXs2aFundsConfirmationMapper;
import de.adorsys.psd2.xs2a.service.mapper.spi_xs2a_mappers.Xs2aToSpiFundsConfirmationRequestMapper;
import de.adorsys.psd2.xs2a.service.profile.AspspProfileServiceWrapper;
import de.adorsys.psd2.xs2a.service.validator.piis.PiisConsentValidation;
import de.adorsys.psd2.xs2a.spi.domain.SpiContextData;
import de.adorsys.psd2.xs2a.spi.domain.fund.SpiFundsConfirmationRequest;
import de.adorsys.psd2.xs2a.spi.domain.fund.SpiFundsConfirmationResponse;
import de.adorsys.psd2.xs2a.spi.domain.response.SpiResponse;
import de.adorsys.psd2.xs2a.spi.service.FundsConfirmationSpi;
import java.beans.ConstructorProperties;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class FundsConfirmationService {
    private static final Logger log = LoggerFactory.getLogger(FundsConfirmationService.class);
    private final AspspProfileServiceWrapper profileService;
    private final FundsConfirmationSpi fundsConfirmationSpi;
    private final FundsConfirmationConsentDataService fundsConfirmationConsentDataService;
    private final SpiContextDataProvider spiContextDataProvider;
    private final Xs2aToSpiFundsConfirmationRequestMapper xs2aToSpiFundsConfirmationRequestMapper;
    private final SpiToXs2aFundsConfirmationMapper spiToXs2aFundsConfirmationMapper;
    private final PiisConsentValidation piisConsentValidation;
    private final PiisConsentService piisConsentService;
    private final Xs2aEventService xs2aEventService;
    private final SpiErrorMapper spiErrorMapper;
    private final RequestProviderService requestProviderService;

    public ResponseObject<FundsConfirmationResponse> fundsConfirmation(FundsConfirmationRequest request) {
        this.xs2aEventService.recordTppRequest(EventType.FUNDS_CONFIRMATION_REQUEST_RECEIVED, request);
        PiisConsent consent = null;
        if (this.profileService.isPiisConsentSupported()) {
            AccountReference accountReference = request.getPsuAccount();
            PiisConsentValidationResult validationResult = this.validateAccountReference(accountReference);
            if (validationResult.hasError()) {
                ErrorHolder errorHolder = validationResult.getErrorHolder();
                log.info("InR-ID: [{}], X-Request-ID: [{}]. Check availability of funds validation failed: {}", new Object[]{this.requestProviderService.getInternalRequestId(), this.requestProviderService.getRequestId(), errorHolder});
                return ResponseObject.builder().fail(new MessageError(errorHolder)).build();
            }
            consent = validationResult.getConsent();
        }
        PsuIdData psuIdData = this.requestProviderService.getPsuIdData();
        log.info("X-Request-ID: [{}]. Corresponding PSU-ID {} was provided from request.", (Object)this.requestProviderService.getRequestId(), (Object)psuIdData);
        AspspConsentData aspspConsentData = this.getAspspConsentData(consent);
        FundsConfirmationResponse response = this.executeRequest(psuIdData, consent, request, aspspConsentData);
        if (response.hasError()) {
            ErrorHolder errorHolder = response.getErrorHolder();
            return ResponseObject.builder().fail(new MessageError(errorHolder)).build();
        }
        return ResponseObject.builder().body(response).build();
    }

    private PiisConsentValidationResult validateAccountReference(AccountReference accountReference) {
        AccountReferenceSelector selector = accountReference.getUsedAccountReferenceSelector();
        if (selector == null) {
            log.info("InR-ID: [{}], X-Request-ID: [{}]. Check availability of funds failed, because while validate account reference no account identifier found in the request [{}].", new Object[]{this.requestProviderService.getInternalRequestId(), this.requestProviderService.getRequestId(), accountReference});
            return new PiisConsentValidationResult(ErrorHolder.builder(MessageErrorCode.FORMAT_ERROR).errorType(ErrorType.PIIS_400).build());
        }
        List response = this.piisConsentService.getPiisConsentListByAccountIdentifier(accountReference.getCurrency(), selector);
        return this.piisConsentValidation.validatePiisConsentData(response);
    }

    private FundsConfirmationResponse executeRequest(@NotNull PsuIdData psuIdData, @Nullable PiisConsent consent, @NotNull FundsConfirmationRequest request, @NotNull AspspConsentData aspspConsentData) {
        SpiFundsConfirmationRequest spiRequest = this.xs2aToSpiFundsConfirmationRequestMapper.mapToSpiFundsConfirmationRequest(request);
        SpiContextData spiContextData = this.spiContextDataProvider.provideWithPsuIdData(psuIdData);
        SpiResponse fundsSufficientCheck = this.fundsConfirmationSpi.performFundsSufficientCheck(spiContextData, consent, spiRequest, aspspConsentData);
        if (consent != null) {
            AspspConsentData newAspspConsentData = fundsSufficientCheck.getAspspConsentData();
            this.fundsConfirmationConsentDataService.updateAspspConsentData(newAspspConsentData);
        }
        if (fundsSufficientCheck.hasError()) {
            ErrorHolder error = this.spiErrorMapper.mapToErrorHolder(fundsSufficientCheck, ServiceType.PIIS);
            log.info("InR-ID: [{}], X-Request-ID: [{}]. Check availability of funds failed, because perform funds sufficient check failed. Msg error: {}", new Object[]{this.requestProviderService.getInternalRequestId(), this.requestProviderService.getRequestId(), error});
            return new FundsConfirmationResponse(error);
        }
        return this.spiToXs2aFundsConfirmationMapper.mapToFundsConfirmationResponse((SpiFundsConfirmationResponse)fundsSufficientCheck.getPayload());
    }

    @NotNull
    private AspspConsentData getAspspConsentData(@Nullable PiisConsent consent) {
        if (consent == null) {
            return AspspConsentData.emptyConsentData();
        }
        return this.fundsConfirmationConsentDataService.getAspspConsentData(consent.getId());
    }

    @ConstructorProperties(value={"profileService", "fundsConfirmationSpi", "fundsConfirmationConsentDataService", "spiContextDataProvider", "xs2aToSpiFundsConfirmationRequestMapper", "spiToXs2aFundsConfirmationMapper", "piisConsentValidation", "piisConsentService", "xs2aEventService", "spiErrorMapper", "requestProviderService"})
    public FundsConfirmationService(AspspProfileServiceWrapper profileService, FundsConfirmationSpi fundsConfirmationSpi, FundsConfirmationConsentDataService fundsConfirmationConsentDataService, SpiContextDataProvider spiContextDataProvider, Xs2aToSpiFundsConfirmationRequestMapper xs2aToSpiFundsConfirmationRequestMapper, SpiToXs2aFundsConfirmationMapper spiToXs2aFundsConfirmationMapper, PiisConsentValidation piisConsentValidation, PiisConsentService piisConsentService, Xs2aEventService xs2aEventService, SpiErrorMapper spiErrorMapper, RequestProviderService requestProviderService) {
        this.profileService = profileService;
        this.fundsConfirmationSpi = fundsConfirmationSpi;
        this.fundsConfirmationConsentDataService = fundsConfirmationConsentDataService;
        this.spiContextDataProvider = spiContextDataProvider;
        this.xs2aToSpiFundsConfirmationRequestMapper = xs2aToSpiFundsConfirmationRequestMapper;
        this.spiToXs2aFundsConfirmationMapper = spiToXs2aFundsConfirmationMapper;
        this.piisConsentValidation = piisConsentValidation;
        this.piisConsentService = piisConsentService;
        this.xs2aEventService = xs2aEventService;
        this.spiErrorMapper = spiErrorMapper;
        this.requestProviderService = requestProviderService;
    }
}

