/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.component;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.beans.ConstructorProperties;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class JsonConverter {
    private static final Logger log = LoggerFactory.getLogger(JsonConverter.class);
    private final ObjectMapper objectMapper;

    public <T> Optional<String> toJson(T object) {
        try {
            return Optional.ofNullable(this.objectMapper.writeValueAsString(object));
        }
        catch (JsonProcessingException e) {
            log.info("Can't convert object to json: {}", (Object)e.getMessage());
            return Optional.empty();
        }
    }

    public <T> Optional<T> toObject(String json, Class<T> target) {
        try {
            return Optional.ofNullable(this.objectMapper.readValue(json, target));
        }
        catch (IOException e) {
            log.info("Can't convert json to object: {}", (Object)e.getMessage());
            return Optional.empty();
        }
    }

    public <T> Optional<T> toObject(byte[] bytes, TypeReference valueTypeRef) {
        try {
            return Optional.ofNullable(this.objectMapper.readValue(IOUtils.toString((byte[])bytes, (String)"UTF-8"), valueTypeRef));
        }
        catch (IOException e) {
            log.info("Can't convert json to object: {}", (Object)e.getMessage());
            return Optional.empty();
        }
    }

    public <T> Optional<T> toJsonField(InputStream stream, String fieldName, TypeReference<T> typeReference) {
        try {
            JsonNode jsonNode = this.objectMapper.readTree(stream);
            JsonNode fieldNode = jsonNode.get(fieldName);
            if (fieldNode == null) {
                log.info("Couldn't extract field from json, because there is no this field {} at json.", (Object)fieldName);
                return Optional.empty();
            }
            Object value = this.objectMapper.readValue(this.objectMapper.treeAsTokens((TreeNode)fieldNode), typeReference);
            return Optional.ofNullable(value);
        }
        catch (IOException e) {
            log.info("Couldn't extract field {} from json: {}", (Object)fieldName, (Object)e.getMessage());
            return Optional.empty();
        }
    }

    public List<String> toJsonGetValuesForField(InputStream stream, String fieldName) {
        ArrayList<String> values = new ArrayList<String>();
        try {
            JsonNode jsonNode = this.objectMapper.readTree(stream);
            values.addAll(jsonNode.findValuesAsText(fieldName));
        }
        catch (IOException e) {
            log.info("Couldn't extract field {} from json: {}", (Object)fieldName, (Object)e.getMessage());
        }
        return values;
    }

    @ConstructorProperties(value={"objectMapper"})
    public JsonConverter(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }
}

