/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.web.validator;

import de.adorsys.psd2.xs2a.domain.MessageErrorCode;
import de.adorsys.psd2.xs2a.domain.TppMessageInformation;
import de.adorsys.psd2.xs2a.service.mapper.psd2.ErrorType;
import de.adorsys.psd2.xs2a.service.validator.ValidationResult;
import de.adorsys.psd2.xs2a.web.validator.common.TppRedirectUriValidationService;
import java.beans.ConstructorProperties;
import javax.servlet.http.HttpServletRequest;
import org.springframework.stereotype.Service;

@Service
public class PaymentControllerHeadersValidationService {
    private final HttpServletRequest httpServletRequest;
    private final TppRedirectUriValidationService tppRedirectUriValidationService;

    public ValidationResult validateInitiatePayment() {
        String tppRedirectUri;
        boolean tppRedirectPreferred = Boolean.parseBoolean(this.httpServletRequest.getHeader("TPP-Redirect-Preferred"));
        if (this.tppRedirectUriValidationService.isNotValid(tppRedirectPreferred, tppRedirectUri = this.httpServletRequest.getHeader("TPP-Redirect-URI"))) {
            return ValidationResult.invalid(ErrorType.PIS_400, TppMessageInformation.of(MessageErrorCode.FORMAT_ERROR, "TPP-Redirect-URI is not correct or empty"));
        }
        return ValidationResult.valid();
    }

    @ConstructorProperties(value={"httpServletRequest", "tppRedirectUriValidationService"})
    public PaymentControllerHeadersValidationService(HttpServletRequest httpServletRequest, TppRedirectUriValidationService tppRedirectUriValidationService) {
        this.httpServletRequest = httpServletRequest;
        this.tppRedirectUriValidationService = tppRedirectUriValidationService;
    }
}

