/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.web.mapper;

import de.adorsys.psd2.api.ConsentApi;
import de.adorsys.psd2.model.ScaStatusResponse;
import de.adorsys.psd2.model.StartScaprocessResponse;
import de.adorsys.psd2.xs2a.core.profile.ScaApproach;
import de.adorsys.psd2.xs2a.core.sca.ScaStatus;
import de.adorsys.psd2.xs2a.domain.consent.CreateConsentAuthorizationResponse;
import de.adorsys.psd2.xs2a.service.ScaApproachResolver;
import de.adorsys.psd2.xs2a.service.profile.AspspProfileServiceWrapper;
import de.adorsys.psd2.xs2a.web.RedirectLinkBuilder;
import de.adorsys.psd2.xs2a.web.mapper.CoreObjectsMapper;
import java.beans.ConstructorProperties;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.Collections;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.hateoas.mvc.ControllerLinkBuilder;
import org.springframework.stereotype.Service;
import org.springframework.web.util.UriComponentsBuilder;

@Service
public class AuthorisationMapper {
    private static final Logger log = LoggerFactory.getLogger(AuthorisationMapper.class);
    private final CoreObjectsMapper coreObjectsMapper;
    private final ScaApproachResolver scaApproachResolver;
    private final RedirectLinkBuilder redirectLinkBuilder;
    private final AspspProfileServiceWrapper profileService;

    public StartScaprocessResponse mapToStartScaProcessResponse(CreateConsentAuthorizationResponse createConsentAuthorizationResponse) {
        return Optional.ofNullable(createConsentAuthorizationResponse).map(csar -> {
            boolean redirectApproachUsed = this.scaApproachResolver.resolveScaApproach() == ScaApproach.REDIRECT;
            String link = redirectApproachUsed ? this.redirectLinkBuilder.buildConsentScaRedirectLink(csar.getConsentId(), csar.getAuthorizationId()) : this.createUpdateConsentsPsuDataLink((CreateConsentAuthorizationResponse)csar).toString();
            return new StartScaprocessResponse().scaStatus(this.coreObjectsMapper.mapToModelScaStatus(createConsentAuthorizationResponse.getScaStatus()))._links(Collections.singletonMap(csar.getResponseLinkType().getValue(), link));
        }).orElse(null);
    }

    private String createUpdateConsentsPsuDataLink(CreateConsentAuthorizationResponse csar) {
        URL baseUrl = null;
        try {
            baseUrl = this.profileService.getXs2aBaseUrl() != null ? new URL(this.profileService.getXs2aBaseUrl()) : null;
        }
        catch (MalformedURLException e) {
            log.error("invalid base url", (Throwable)e);
        }
        URI uri = ControllerLinkBuilder.linkTo((Object)((ConsentApi)ControllerLinkBuilder.methodOn(ConsentApi.class, (Object[])new Object[0]))._updateConsentsPsuData(null, csar.getConsentId(), csar.getAuthorizationId(), null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null)).toUri();
        UriComponentsBuilder uriComponentsBuilder = UriComponentsBuilder.newInstance();
        uriComponentsBuilder.scheme(uri.getScheme());
        uriComponentsBuilder.host(uri.getHost());
        uriComponentsBuilder.port(uri.getPort());
        Optional.ofNullable(baseUrl).ifPresent(url -> {
            uriComponentsBuilder.scheme(url.getProtocol());
            uriComponentsBuilder.host(url.getHost());
            uriComponentsBuilder.port(url.getPort());
            uriComponentsBuilder.path(url.getPath());
        });
        uriComponentsBuilder.path(uri.getPath());
        return uriComponentsBuilder.toUriString();
    }

    @NotNull
    public ScaStatusResponse mapToScaStatusResponse(@NotNull ScaStatus scaStatus) {
        return new ScaStatusResponse().scaStatus(this.coreObjectsMapper.mapToModelScaStatus(scaStatus));
    }

    @ConstructorProperties(value={"coreObjectsMapper", "scaApproachResolver", "redirectLinkBuilder", "profileService"})
    public AuthorisationMapper(CoreObjectsMapper coreObjectsMapper, ScaApproachResolver scaApproachResolver, RedirectLinkBuilder redirectLinkBuilder, AspspProfileServiceWrapper profileService) {
        this.coreObjectsMapper = coreObjectsMapper;
        this.scaApproachResolver = scaApproachResolver;
        this.redirectLinkBuilder = redirectLinkBuilder;
        this.profileService = profileService;
    }
}

