/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.web.interceptor;

import com.fasterxml.jackson.databind.ObjectMapper;
import de.adorsys.psd2.xs2a.domain.MessageErrorCode;
import de.adorsys.psd2.xs2a.domain.TppMessageInformation;
import de.adorsys.psd2.xs2a.exception.MessageError;
import de.adorsys.psd2.xs2a.service.discovery.ServiceTypeDiscoveryService;
import de.adorsys.psd2.xs2a.service.mapper.psd2.ErrorMapperContainer;
import de.adorsys.psd2.xs2a.service.mapper.psd2.ErrorType;
import de.adorsys.psd2.xs2a.service.mapper.psd2.ServiceTypeToErrorTypeMapper;
import de.adorsys.psd2.xs2a.service.validator.RequestValidatorService;
import java.beans.ConstructorProperties;
import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;

@Component
public class HandlerInterceptor
extends HandlerInterceptorAdapter {
    private static final Logger log = LoggerFactory.getLogger(HandlerInterceptor.class);
    private final RequestValidatorService requestValidatorService;
    private final ServiceTypeDiscoveryService serviceTypeDiscoveryService;
    private final ServiceTypeToErrorTypeMapper errorTypeMapper;
    private final ErrorMapperContainer errorMapperContainer;
    private final ObjectMapper objectMapper;

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws IOException {
        return this.isRequestValidAndSendRespIfError(request, response, handler);
    }

    private boolean isRequestValidAndSendRespIfError(HttpServletRequest request, HttpServletResponse response, Object handler) throws IOException {
        Map<String, String> violationsMap = this.requestValidatorService.getRequestViolationMap(request, handler);
        if (violationsMap.isEmpty()) {
            return true;
        }
        Map.Entry<String, String> firstError = violationsMap.entrySet().iterator().next();
        MessageErrorCode messageCode = this.getActualMessageErrorCode(firstError.getKey());
        log.debug("Handled error {}", (Object)(messageCode.name() + ": " + firstError.getValue()));
        response.resetBuffer();
        response.setStatus(messageCode.getCode());
        response.setCharacterEncoding("UTF-8");
        response.setHeader("Content-Type", "application/json");
        response.getWriter().write(this.objectMapper.writeValueAsString(this.createError(messageCode, violationsMap.values())));
        response.flushBuffer();
        return false;
    }

    private MessageErrorCode getActualMessageErrorCode(String error) {
        return MessageErrorCode.getByName(error).orElse(MessageErrorCode.FORMAT_ERROR);
    }

    private Object createError(MessageErrorCode errorCode, Collection<String> errorMessages) {
        MessageError messageError = this.getMessageError(errorCode, errorMessages);
        return Optional.ofNullable(this.errorMapperContainer.getErrorBody(messageError)).map(ErrorMapperContainer.ErrorBody::getBody).orElse(null);
    }

    private MessageError getMessageError(MessageErrorCode errorCode, Collection<String> errorMessages) {
        ErrorType errorType = this.errorTypeMapper.mapToErrorType(this.serviceTypeDiscoveryService.getServiceType(), errorCode.getCode());
        TppMessageInformation[] tppMessages = (TppMessageInformation[])errorMessages.stream().map(e -> TppMessageInformation.of(errorCode, e)).toArray(TppMessageInformation[]::new);
        return new MessageError(errorType, tppMessages);
    }

    @ConstructorProperties(value={"requestValidatorService", "serviceTypeDiscoveryService", "errorTypeMapper", "errorMapperContainer", "objectMapper"})
    public HandlerInterceptor(RequestValidatorService requestValidatorService, ServiceTypeDiscoveryService serviceTypeDiscoveryService, ServiceTypeToErrorTypeMapper errorTypeMapper, ErrorMapperContainer errorMapperContainer, ObjectMapper objectMapper) {
        this.requestValidatorService = requestValidatorService;
        this.serviceTypeDiscoveryService = serviceTypeDiscoveryService;
        this.errorTypeMapper = errorTypeMapper;
        this.errorMapperContainer = errorMapperContainer;
        this.objectMapper = objectMapper;
    }
}

